package net.kappasmp.kappaessentials.teleport;

import com.mojang.brigadier.CommandDispatcher;
import java.util.EnumSet;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3222;

public class TpAcceptCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("tpaccept")
                .executes(context -> {
                    class_3222 receiver = context.getSource().method_44023();

                    if (!TeleportRequestManager.hasRequest(receiver)) {
                        receiver.method_7353(class_2561.method_43470("§cNo pending teleport requests."), false);
                        return 0;
                    }

                    class_3222 requester = TeleportRequestManager.getRequester(receiver);
                    TeleportRequestManager.Type type = TeleportRequestManager.getType(receiver);

                    if (requester == null || type == null) {
                        receiver.method_7353(class_2561.method_43470("§cTeleport request is no longer valid."), false);
                        return 0;
                    }

                    if (type == TeleportRequestManager.Type.TPA) {
                        requester.method_48105(
                                receiver.method_51469(),
                                receiver.method_23317(), receiver.method_23318(), receiver.method_23321(),
                                EnumSet.noneOf(class_2709.class),
                                requester.method_36454(), requester.method_36455(),
                                false
                        );
                        requester.method_7353(class_2561.method_43470("§aTeleported to " + receiver.method_5477().getString()), false);
                    } else {
                        receiver.method_48105(
                                requester.method_51469(),
                                requester.method_23317(), requester.method_23318(), requester.method_23321(),
                                EnumSet.noneOf(class_2709.class),
                                receiver.method_36454(), receiver.method_36455(),
                                false
                        );
                        receiver.method_7353(class_2561.method_43470("§aTeleported to " + requester.method_5477().getString()), false);
                    }

                    TeleportRequestManager.clearRequest(receiver);
                    return 1;
                })
        );
    }
}
