package net.kappasmp.kappaessentials.token;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class TokenTopCommand {

    public static void register(com.mojang.brigadier.CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(LiteralArgumentBuilder.<class_2168>literal("tokentop")
                .requires(source -> source.method_9259(0))
                .executes(context -> execute(context.getSource()))
        );
    }

    private static int execute(class_2168 source) {
        var topTokens = TokenManager.getTopTokens(10);
        source.method_45068(class_2561.method_43470("§6§lTop 10 Tokens:"));
        int rank = 1;
        for (Map.Entry<UUID, Integer> entry : topTokens) {
            String name = getPlayerName(source, entry.getKey());
            String formatted = formatTokens(entry.getValue());
            source.method_45068(class_2561.method_43470("§6§l" + rank + ". §7" + name + " - " + formatted + " Tokens"));
            rank++;
        }
        return Command.SINGLE_SUCCESS;
    }

    private static String formatTokens(int tokens) {
        double value = tokens;
        if (value >= 1_000_000_000) {
            return String.format("%.2fb", value / 1_000_000_000);
        } else if (value >= 1_000_000) {
            return String.format("%.2fm", value / 1_000_000);
        } else if (value >= 1_000) {
            return String.format("%.2fk", value / 1_000);
        } else {
            return String.format("%.0f", value); // No decimals
        }
    }

    private static String getPlayerName(class_2168 source, UUID uuid) {
        var player = source.method_9211().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_5477().getString();
        } else {
            Optional<com.mojang.authlib.GameProfile> profile = source.method_9211().method_3793().method_14512(uuid);
            return profile.map(com.mojang.authlib.GameProfile::getName).orElse(uuid.toString().substring(0, 8));
        }
    }
}
