package net.kappasmp.kappaessentials.util;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.*;

public class TaskScheduler {

    private static final Map<UUID, ScheduledTeleport> activeTeleports = new HashMap<>();
    private static final List<ScheduledMessage> scheduledMessages = new LinkedList<>();

    static {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            // Handle teleport tasks
            Iterator<Map.Entry<UUID, ScheduledTeleport>> teleportIterator = activeTeleports.entrySet().iterator();
            while (teleportIterator.hasNext()) {
                Map.Entry<UUID, ScheduledTeleport> entry = teleportIterator.next();
                ScheduledTeleport task = entry.getValue();
                class_3222 player = server.method_3760().method_14602(entry.getKey());

                if (player == null || player.method_14239()) {
                    teleportIterator.remove();
                    continue;
                }

                if (!player.method_24515().equals(task.startPos)) {
                    player.method_7353(task.cancelMessage, false);
                    teleportIterator.remove();
                    continue;
                }

                task.delay--;
                if (task.delay <= 0) {
                    task.action.run();
                    teleportIterator.remove();
                }
            }

            // Handle scheduled chat messages
            Iterator<ScheduledMessage> messageIterator = scheduledMessages.iterator();
            while (messageIterator.hasNext()) {
                ScheduledMessage message = messageIterator.next();
                message.delay--;
                if (message.delay <= 0) {
                    class_3222 player = server.method_3760().method_14602(message.playerId);
                    if (player != null && !player.method_14239()) {
                        message.action.run();
                    }
                    messageIterator.remove();
                }
            }
        });
    }

    public static void scheduleTeleport(class_3222 player, int delayTicks, Runnable action, String homeName) {
        class_2338 currentPos = player.method_24515();
        activeTeleports.put(player.method_5667(), new ScheduledTeleport(
                delayTicks,
                action,
                currentPos,
                class_2561.method_43470("§cTeleport to §e" + homeName + "§c cancelled: you moved.")
        ));
    }

    public static void scheduleMessage(class_3222 player, int delayTicks, Runnable action) {
        scheduledMessages.add(new ScheduledMessage(player.method_5667(), delayTicks, action));
    }

    private static class ScheduledTeleport {
        int delay;
        Runnable action;
        class_2338 startPos;
        class_2561 cancelMessage;

        ScheduledTeleport(int delay, Runnable action, class_2338 startPos, class_2561 cancelMessage) {
            this.delay = delay;
            this.action = action;
            this.startPos = startPos;
            this.cancelMessage = cancelMessage;
        }
    }

    private static class ScheduledMessage {
        UUID playerId;
        int delay;
        Runnable action;

        ScheduledMessage(UUID playerId, int delay, Runnable action) {
            this.playerId = playerId;
            this.delay = delay;
            this.action = action;
        }
    }
}
