/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BalTopCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"baltop").requires(source -> source.method_9259(0))).executes(context -> BalTopCommand.execute((class_2168)context.getSource())));
    }

    private static int execute(class_2168 source) {
        List<Map.Entry<UUID, Integer>> topBalances = BalanceManager.getTopBalances(10);
        source.method_45068((class_2561)class_2561.method_43470((String)"\u00a76\u00a7lTop 10 Balances:"));
        int rank = 1;
        for (Map.Entry<UUID, Integer> entry : topBalances) {
            String name = BalTopCommand.getPlayerName(source, entry.getKey());
            String formatted = BalTopCommand.formatBalance(entry.getValue());
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a76\u00a7l" + rank + ". \u00a77" + name + " - $" + formatted)));
            ++rank;
        }
        return 1;
    }

    private static String formatBalance(int balance) {
        double value = balance;
        if (value >= 1.0E9) {
            return String.format("%.2fb", value / 1.0E9);
        }
        if (value >= 1000000.0) {
            return String.format("%.2fm", value / 1000000.0);
        }
        if (value >= 1000.0) {
            return String.format("%.2fk", value / 1000.0);
        }
        return String.format("%.2f", value);
    }

    private static String getPlayerName(class_2168 source, UUID uuid) {
        class_3222 player = source.method_9211().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_5477().getString();
        }
        Optional profile = source.method_9211().method_3793().method_14512(uuid);
        return profile.map(GameProfile::getName).orElse(uuid.toString().substring(0, 8));
    }
}

