/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.enderchest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class EnderChest
extends JavaPlugin
implements Listener,
CommandExecutor {
    private String prefix;
    private int customSize;
    private String openSound;
    private String closeSound;
    private File dataFolder;
    private static final String INVENTORY_TITLE = String.valueOf(ChatColor.LIGHT_PURPLE) + "Ender Chest";

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getCommand("ec").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.dataFolder = new File(this.getDataFolder(), "data");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.getLogger().info("EnderChest has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("EnderChest has been disabled!");
    }

    private void loadConfigValues() {
        this.reloadConfig();
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("prefix", "&5&lEnderChest &r&l>>> &7"));
        int sizeConfig = this.getConfig().getInt("size", 1);
        if (sizeConfig < 1) {
            sizeConfig = 1;
        } else if (sizeConfig > 2) {
            sizeConfig = 2;
            this.getLogger().warning("Invalid Ender Chest size in config.yml. Capping at 2.");
        }
        this.customSize = sizeConfig;
        this.openSound = this.getConfig().getString("sounds.open", "BLOCK_ENDER_CHEST_OPEN");
        this.closeSound = this.getConfig().getString("sounds.close", "BLOCK_ENDER_CHEST_CLOSE");
    }

    private void openCustomEnderChest(Player player) {
        int rows = this.customSize * 3;
        if (rows > 6) {
            rows = 6;
            player.sendMessage(this.prefix + String.valueOf(ChatColor.YELLOW) + "The maximum size for a chest GUI is 6 rows. The size has been capped.");
        }
        Inventory customEnderChest = Bukkit.createInventory(null, (int)(rows * 9), (String)INVENTORY_TITLE);
        int newSize = rows * 9;
        ItemStack[] loadedItems = this.loadInventory(player);
        if (loadedItems != null) {
            int i;
            if (loadedItems.length > newSize) {
                int droppedItemsCount = 0;
                i = newSize;
                while (i < loadedItems.length) {
                    if (loadedItems[i] != null) {
                        player.getWorld().dropItem(player.getLocation(), loadedItems[i]);
                        ++droppedItemsCount;
                    }
                    ++i;
                }
                if (droppedItemsCount > 0) {
                    player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "Because the size of your Ender Chest has been reduced, " + droppedItemsCount + " items have been dropped on the ground.");
                }
            }
            ItemStack[] scaledItems = new ItemStack[newSize];
            i = 0;
            while (i < loadedItems.length && i < scaledItems.length) {
                scaledItems[i] = loadedItems[i];
                ++i;
            }
            customEnderChest.setContents(scaledItems);
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Ender Chest content loaded.");
        } else {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GRAY) + "Ender Chest is empty. Start adding items!");
        }
        player.openInventory(customEnderChest);
        try {
            Sound sound = Sound.valueOf((String)this.openSound.toUpperCase());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid sound specified in config: " + this.openSound);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefix + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("ec.reload")) {
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.loadConfigValues();
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully!");
            return true;
        }
        if (!player.hasPermission("ec.use")) {
            player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        this.openCustomEnderChest(player);
        return true;
    }

    @EventHandler
    public void onEnderChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock != null && clickedBlock.getType() == Material.ENDER_CHEST) {
            Player player = event.getPlayer();
            if (!player.hasPermission("ec.use")) {
                player.sendMessage(this.prefix + String.valueOf(ChatColor.RED) + "You don't have permission to open this Ender Chest.");
                return;
            }
            event.setCancelled(true);
            this.openCustomEnderChest(player);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTitle().equals(INVENTORY_TITLE)) {
            Player player = (Player)event.getPlayer();
            Inventory closedInventory = event.getInventory();
            this.saveInventory(player, closedInventory.getContents());
            player.sendMessage(this.prefix + String.valueOf(ChatColor.GREEN) + "Ender Chest content saved.");
            try {
                Sound sound = Sound.valueOf((String)this.closeSound.toUpperCase());
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid sound specified in config: " + this.closeSound);
            }
        }
    }

    private void saveInventory(Player player, ItemStack[] items) {
        File playerFile = new File(this.dataFolder, player.getUniqueId().toString() + ".data");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(playerFile));){
                String encodedData = EnderChest.itemStackArrayToBase64(items);
                writer.write(encodedData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save Ender Chest for player " + player.getName() + ": " + e.getMessage());
        }
    }

    private ItemStack[] loadInventory(Player player) {
        File playerFile = new File(this.dataFolder, player.getUniqueId().toString() + ".data");
        if (!playerFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(playerFile));){
                String encodedData = reader.readLine();
                if (encodedData != null) {
                    return EnderChest.itemStackArrayFromBase64(encodedData);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Could not load Ender Chest for player " + player.getName() + ": " + e.getMessage());
        }
        return null;
    }

    public static String itemStackArrayToBase64(ItemStack[] items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            ItemStack[] itemStackArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                dataOutput.writeObject((Object)item);
                ++n2;
            }
            dataOutput.close();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack[] itemStackArrayFromBase64(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            int i = 0;
            while (i < items.length) {
                items[i] = (ItemStack)dataInput.readObject();
                ++i;
            }
            dataInput.close();
            return items;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Unable to decode item stacks.", e);
        }
    }
}

