/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl;

import com.mrbysco.sfl.client.ClientHandler;
import com.mrbysco.sfl.config.SFLConfig;
import com.mrbysco.sfl.entity.AbstractMimicEntity;
import com.mrbysco.sfl.init.MimicEntities;
import com.mrbysco.sfl.init.MimicRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sfl")
public class ServerFriendlyLoot {
    public static final String MOD_ID = "sfl";
    public static final Logger LOGGER = LogManager.getLogger();

    public ServerFriendlyLoot(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SFLConfig.spawnSpec, "sfl_spawning.toml");
        eventBus.register(SFLConfig.class);
        MimicRegistry.ENTITY_TYPES.register(eventBus);
        MimicRegistry.ITEMS.register(eventBus);
        eventBus.addListener(MimicEntities::registerSpawnPlacements);
        eventBus.addListener(MimicEntities::registerEntityAttributes);
        eventBus.addListener(this::addTabContents);
        NeoForge.EVENT_BUS.addListener(this::onFinalizeSpawn);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::registerEntityRenders);
            eventBus.addListener(ClientHandler::registerLayerDefinitions);
        }
    }

    private void addTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            List<ItemStack> stacks = MimicRegistry.ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            event.acceptAll(stacks);
        }
    }

    private void onFinalizeSpawn(FinalizeSpawnEvent event) {
        List blacklist;
        if (event.getSpawnType().equals((Object)MobSpawnType.NATURAL) && event.getEntity() instanceof AbstractMimicEntity && !(blacklist = (List)SFLConfig.SPAWN.dimension_blacklist.get()).isEmpty()) {
            ResourceLocation dimensionLocation = ((Level)event.getLevel()).dimension().location();
            for (String dimension : blacklist) {
                ResourceLocation dimLoc;
                if (dimension.isEmpty() || (dimLoc = ResourceLocation.tryParse((String)dimension)) == null || !dimLoc.equals((Object)dimensionLocation)) continue;
                event.setSpawnCancelled(true);
            }
        }
    }
}

