/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.compat.ct;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.mrbysco.sfl.init.MimicLootHandler;
import net.minecraft.resources.ResourceLocation;

public class RemoveDimensionalTableAction
implements IUndoableAction {
    public final String dimension;
    public final ResourceLocation lootTable;

    public RemoveDimensionalTableAction(String dim, String table) {
        this.dimension = dim;
        this.lootTable = ResourceLocation.tryParse((String)table);
    }

    public void apply() {
        MimicLootHandler.removeDimensionalTable(ResourceLocation.tryParse((String)this.dimension), this.lootTable);
    }

    public String describe() {
        return String.format("Loot table: " + this.lootTable.toString() + " has been removed from dimension " + this.dimension + " of the Mimic loot list", new Object[0]);
    }

    public void undo() {
        MimicLootHandler.addDimensionalTable(ResourceLocation.tryParse((String)this.dimension), this.lootTable);
    }

    public String describeUndo() {
        return String.format("Loot table: " + this.lootTable.toString() + " has been re-added to dimension " + this.dimension + " of the Mimic loot list", new Object[0]);
    }

    public String systemName() {
        return "Server Friendly Looting";
    }
}

