/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.datagen;

import com.mrbysco.sfl.datagen.SFLBiomeModifiers;
import com.mrbysco.sfl.init.MimicRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Cloner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SFLDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new SFLLanguageProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(SFLDatagen::getProvider), Set.of("sfl")));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, $ -> {});
        registryBuilder.add(Registries.PLACED_FEATURE, $ -> {});
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, SFLBiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    public static class SFLLanguageProvider
    extends LanguageProvider {
        public SFLLanguageProvider(PackOutput packOutput) {
            super(packOutput, "sfl", "en_us");
        }

        protected void addTranslations() {
            this.addItem((Supplier)MimicRegistry.MIMIC_SPAWN_EGG, "Mimic Spawn Egg");
            this.addItem((Supplier)MimicRegistry.WATER_MIMIC_SPAWN_EGG, "Water Mimic Spawn Egg");
            this.addItem((Supplier)MimicRegistry.END_MIMIC_SPAWN_EGG, "End Mimic Spawn Egg");
            this.addItem((Supplier)MimicRegistry.NETHER_MIMIC_SPAWN_EGG, "Nether Mimic Spawn Egg");
            this.addEntityType(MimicRegistry.MIMIC, "Mimic");
            this.addEntityType(MimicRegistry.WATER_MIMIC, "Mimic");
            this.addEntityType(MimicRegistry.END_MIMIC, "End Mimic");
            this.addEntityType(MimicRegistry.NETHER_MIMIC, "Nether Mimic");
            this.addConfig("general", "General", "Configure General Mimic settings");
            this.addConfig("dimensionBlacklist", "Dimension Blacklist", "Dimensions in which the mimic's can't spawn");
        }

        public void addSubtitle(Supplier<SoundEvent> sound, String name) {
            this.addSubtitle(sound.get(), name);
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "sfl.subtitle." + sound.getLocation().getPath();
            this.add(path, name);
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("sfl.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("sfl.configuration." + path + ".tooltip", description);
            }
        }
    }
}

