/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.entity;

import com.mrbysco.sfl.init.MimicLootHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class AbstractMimicEntity
extends Monster {
    private ResourceKey<LootTable> defaultLootTable;

    public AbstractMimicEntity(EntityType<? extends AbstractMimicEntity> type, Level level) {
        super(type, level);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return true;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.defaultLootTable;
    }

    protected void dropFromLootTable(DamageSource damageSourceIn, boolean wasRecentlyHit) {
        ResourceKey resourcelocation = this.getLootTable();
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(resourcelocation);
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSourceIn).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSourceIn.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSourceIn.getDirectEntity());
        if (wasRecentlyHit && this.lastHurtByPlayer != null) {
            lootcontext$builder = lootcontext$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        ObjectArrayList loot = loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.ENTITY));
        int stackAmount = 1;
        Entity entity = damageSourceIn.getEntity();
        if (entity instanceof Player) {
            int looting;
            Player player = (Player)entity;
            if (!(damageSourceIn.getEntity() instanceof FakePlayer) && (looting = player.getMainHandItem().getEnchantmentLevel(this.level().holderOrThrow(Enchantments.LOOTING))) > 0) {
                stackAmount = looting + 1;
            }
        }
        if (stackAmount > 1) {
            if (stackAmount > loot.size()) {
                for (ItemStack stack : loot) {
                    this.spawnAtLocation(stack);
                }
            } else {
                for (int i = 0; i < stackAmount; ++i) {
                    this.spawnAtLocation((ItemStack)loot.get(i));
                }
            }
        } else {
            int randNumber = !loot.isEmpty() ? this.random.nextInt(loot.size()) : 1;
            this.spawnAtLocation((ItemStack)loot.get(randNumber));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DefaultLootTable", this.defaultLootTable.toString());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.defaultLootTable = this.getLootKey(ResourceLocation.tryParse((String)compound.getString("DefaultLootTable")));
    }

    private ResourceKey<LootTable> getLootKey(ResourceLocation location) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)location);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        SpawnGroupData data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, groupData);
        ArrayList<ResourceLocation> tables = MimicLootHandler.getDimensionTables((ResourceKey<Level>)this.level().dimension());
        if (tables.isEmpty()) {
            this.defaultLootTable = BuiltInLootTables.VILLAGE_FISHER;
        } else {
            int idx = this.random.nextInt(tables.size());
            this.defaultLootTable = this.getLootKey(tables.get(idx));
        }
        return data;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CHEST_LOCKED;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CHEST_OPEN;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CHEST_CLOSE;
    }

    public static boolean spawnPredicate(EntityType<? extends AbstractMimicEntity> typeIn, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL && !levelAccessor.getBiome(pos).is(Tags.Biomes.NO_DEFAULT_MONSTERS) && AbstractMimicEntity.checkMobSpawnRules(typeIn, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource);
    }
}

