/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.init;

import com.mrbysco.sfl.entity.EndMimicEntity;
import com.mrbysco.sfl.entity.MimicEntity;
import com.mrbysco.sfl.entity.NetherMimicEntity;
import com.mrbysco.sfl.entity.WaterMimicEntity;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MimicRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"sfl");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"sfl");
    public static final Supplier<EntityType<MimicEntity>> MIMIC = ENTITY_TYPES.register("mimic", () -> MimicRegistry.register("mimic", EntityType.Builder.of(MimicEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 0.9f)));
    public static final Supplier<EntityType<EndMimicEntity>> END_MIMIC = ENTITY_TYPES.register("end_mimic", () -> MimicRegistry.register("end_mimic", EntityType.Builder.of(EndMimicEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 0.9f)));
    public static final Supplier<EntityType<NetherMimicEntity>> NETHER_MIMIC = ENTITY_TYPES.register("nether_mimic", () -> MimicRegistry.register("nether_mimic", EntityType.Builder.of(NetherMimicEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 0.9f)));
    public static final Supplier<EntityType<WaterMimicEntity>> WATER_MIMIC = ENTITY_TYPES.register("water_mimic", () -> MimicRegistry.register("water_mimic", EntityType.Builder.of(WaterMimicEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 0.9f)));
    public static final DeferredItem<DeferredSpawnEggItem> MIMIC_SPAWN_EGG = ITEMS.register("mimic_spawn_egg", () -> new DeferredSpawnEggItem(MIMIC, 8282679, 16368742, MimicRegistry.itemBuilder()));
    public static final DeferredItem<DeferredSpawnEggItem> END_MIMIC_SPAWN_EGG = ITEMS.register("end_mimic_spawn_egg", () -> new DeferredSpawnEggItem(END_MIMIC, 1057581, 16368742, MimicRegistry.itemBuilder()));
    public static final DeferredItem<DeferredSpawnEggItem> NETHER_MIMIC_SPAWN_EGG = ITEMS.register("nether_mimic_spawn_egg", () -> new DeferredSpawnEggItem(NETHER_MIMIC, 3151900, 16368742, MimicRegistry.itemBuilder()));
    public static final DeferredItem<DeferredSpawnEggItem> WATER_MIMIC_SPAWN_EGG = ITEMS.register("water_mimic_spawn_egg", () -> new DeferredSpawnEggItem(WATER_MIMIC, 5540220, 16368742, MimicRegistry.itemBuilder()));

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder, boolean sendVelocityUpdates) {
        return builder.setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(sendVelocityUpdates).build(id);
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return MimicRegistry.register(id, builder, true);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }
}

