/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.config;

import com.mrbysco.sfl.ServerFriendlyLoot;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SFLConfig {
    public static final ModConfigSpec spawnSpec;
    public static final Spawn SPAWN;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        ServerFriendlyLoot.LOGGER.debug("Loaded ServerFriendlyLoot's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        ServerFriendlyLoot.LOGGER.fatal("ServerFriendlyLoot's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Spawn::new);
        spawnSpec = (ModConfigSpec)specPair.getRight();
        SPAWN = (Spawn)specPair.getLeft();
    }

    public static class Spawn {
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimension_blacklist;

        Spawn(ModConfigSpec.Builder builder) {
            builder.comment("Configure General Mimic settings").push("general");
            this.dimension_blacklist = builder.comment("Dimensions in which the mimic's can't spawn").defineListAllowEmpty("dimensionBlacklist", List::of, String::new, o -> o instanceof String);
            builder.pop();
        }
    }
}

