/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.datagen.client;

import com.mrbysco.sfl.init.MimicRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class SFLLanguageProvider
extends LanguageProvider {
    public SFLLanguageProvider(PackOutput packOutput) {
        super(packOutput, "sfl", "en_us");
    }

    protected void addTranslations() {
        this.addItem((Supplier)MimicRegistry.MIMIC_SPAWN_EGG, "Mimic Spawn Egg");
        this.addItem((Supplier)MimicRegistry.WATER_MIMIC_SPAWN_EGG, "Water Mimic Spawn Egg");
        this.addItem((Supplier)MimicRegistry.END_MIMIC_SPAWN_EGG, "End Mimic Spawn Egg");
        this.addItem((Supplier)MimicRegistry.NETHER_MIMIC_SPAWN_EGG, "Nether Mimic Spawn Egg");
        this.addEntityType(MimicRegistry.MIMIC, "Mimic");
        this.addEntityType(MimicRegistry.WATER_MIMIC, "Mimic");
        this.addEntityType(MimicRegistry.END_MIMIC, "End Mimic");
        this.addEntityType(MimicRegistry.NETHER_MIMIC, "Nether Mimic");
        this.addConfig("general", "General", "Configure General Mimic settings");
        this.addConfig("dimensionBlacklist", "Dimension Blacklist", "Dimensions in which the mimic's can't spawn");
    }

    public void addSubtitle(Supplier<SoundEvent> sound, String name) {
        this.addSubtitle(sound.get(), name);
    }

    public void addSubtitle(SoundEvent sound, String name) {
        String path = "sfl.subtitle." + sound.location().getPath();
        this.add(path, name);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("sfl.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("sfl.configuration." + path + ".tooltip", description);
        }
    }
}

