/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.entity;

import com.mrbysco.sfl.entity.AbstractMimicEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class WaterMimicEntity
extends AbstractMimicEntity {
    protected final WaterBoundPathNavigation waterNavigator;
    protected final GroundPathNavigation groundNavigator;
    private boolean swimmingUp;

    public WaterMimicEntity(EntityType<? extends WaterMimicEntity> type, Level level) {
        super(type, level);
        this.moveControl = new MoveHelperController(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigator = new GroundPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new SwimUpGoal(this, 1.0, this.level().getSeaLevel()));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractMimicEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isPushedByFluid(FluidType fluidType) {
        return !this.isSwimming();
    }

    public static boolean spawnPredicate(EntityType<? extends AbstractMimicEntity> typeIn, ServerLevelAccessor levelAccessor, EntitySpawnReason spawnType, BlockPos pos, RandomSource randomSource) {
        boolean flag;
        boolean bl = flag = levelAccessor.getDifficulty() != Difficulty.PEACEFUL && WaterMimicEntity.isDarkEnoughToSpawn((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)randomSource) && (spawnType == EntitySpawnReason.SPAWNER || levelAccessor.getFluidState(pos).is(FluidTags.WATER));
        if (!levelAccessor.getBiome(pos).is(BiomeTags.IS_RIVER)) {
            return randomSource.nextInt(40) == 0 && WaterMimicEntity.isUnderSeaLevel((LevelAccessor)levelAccessor, pos) && flag;
        }
        return randomSource.nextInt(15) == 0 && flag;
    }

    private static boolean isUnderSeaLevel(LevelAccessor levelAccessor, BlockPos pos) {
        return pos.getY() < levelAccessor.getSeaLevel() - 5;
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigator;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigator;
                this.setSwimming(false);
            }
        }
    }

    protected boolean isCloseToPathTarget() {
        BlockPos targetPos;
        Path path = this.getNavigation().getPath();
        if (path != null && (targetPos = path.getTarget()) != null) {
            double distance = this.distanceToSqr(targetPos.getX(), targetPos.getY(), targetPos.getZ());
            return distance < 4.0;
        }
        return false;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
            this.moveRelative(0.01f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public void setSwimmingUp(boolean swimmingUp) {
        this.swimmingUp = swimmingUp;
    }

    private boolean wantsToSwim() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity target = this.getTarget();
        return target != null && target.isInWater();
    }

    static class MoveHelperController
    extends MoveControl {
        private final WaterMimicEntity mimic;

        public MoveHelperController(WaterMimicEntity waterMimic) {
            super((Mob)waterMimic);
            this.mimic = waterMimic;
        }

        public void tick() {
            LivingEntity target = this.mimic.getTarget();
            if (this.mimic.wantsToSwim() && this.mimic.isInWater()) {
                if (target != null && target.getY() > this.mimic.getY() || this.mimic.swimmingUp) {
                    this.mimic.setDeltaMovement(this.mimic.getDeltaMovement().add(0.0, 0.002, 0.0));
                }
                if (this.operation != MoveControl.Operation.MOVE_TO || this.mimic.getNavigation().isDone()) {
                    this.mimic.setSpeed(0.0f);
                    return;
                }
                double x = this.wantedX - this.mimic.getX();
                double y = this.wantedY - this.mimic.getY();
                double z = this.wantedZ - this.mimic.getZ();
                double sqrt = Math.sqrt(x * x + y * y + z * z);
                y /= sqrt;
                float lvt_10_1_ = (float)(Mth.atan2((double)z, (double)x) * 57.2957763671875) - 90.0f;
                this.mimic.setYRot(this.rotlerp(this.mimic.getYRot(), lvt_10_1_, 90.0f));
                this.mimic.yBodyRot = this.mimic.getYRot();
                float speed = (float)(this.speedModifier * this.mimic.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                float speedLerped = Mth.lerp((float)0.125f, (float)this.mimic.getSpeed(), (float)speed);
                this.mimic.setSpeed(speedLerped);
                this.mimic.setDeltaMovement(this.mimic.getDeltaMovement().add((double)speedLerped * x * 0.005, (double)speedLerped * y * 0.1, (double)speedLerped * z * 0.005));
            } else {
                if (!this.mimic.onGround()) {
                    this.mimic.setDeltaMovement(this.mimic.getDeltaMovement().add(0.0, -0.008, 0.0));
                }
                super.tick();
            }
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public GoToWaterGoal(PathfinderMob mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.level = mob.level();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.level.isDay()) {
                return false;
            }
            if (this.mob.isInWater()) {
                return false;
            }
            Vec3 waterPos = this.getWaterPos();
            if (waterPos == null) {
                return false;
            }
            this.wantedX = waterPos.x;
            this.wantedY = waterPos.y;
            this.wantedZ = waterPos.z;
            return true;
        }

        public boolean canContinueToUse() {
            return !this.mob.getNavigation().isDone();
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.mob.getRandom();
            BlockPos pos = BlockPos.containing((double)this.mob.getX(), (double)this.mob.getBoundingBox().minY, (double)this.mob.getZ());
            for (int i = 0; i < 10; ++i) {
                BlockPos offPos = pos.offset(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (this.level.getBlockState(offPos).getBlock() != Blocks.WATER) continue;
                return new Vec3((double)offPos.getX(), (double)offPos.getY(), (double)offPos.getZ());
            }
            return null;
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final WaterMimicEntity waterMimicEntity;
        private final double speedModifier;
        private final int targetY;
        private boolean obstructed;

        public SwimUpGoal(WaterMimicEntity waterMimic, double speedModifier, int targetY) {
            this.waterMimicEntity = waterMimic;
            this.speedModifier = speedModifier;
            this.targetY = targetY;
        }

        public boolean canUse() {
            return !this.waterMimicEntity.level().isDay() && this.waterMimicEntity.isInWater() && this.waterMimicEntity.getY() < (double)(this.targetY - 2);
        }

        public boolean canContinueToUse() {
            return this.canUse() && !this.obstructed;
        }

        public void tick() {
            if (this.waterMimicEntity.getY() < (double)(this.targetY - 1) && (this.waterMimicEntity.getNavigation().isDone() || this.waterMimicEntity.isCloseToPathTarget())) {
                Vec3 vec3 = DefaultRandomPos.getPosTowards((PathfinderMob)this.waterMimicEntity, (int)4, (int)8, (Vec3)new Vec3(this.waterMimicEntity.getX(), (double)(this.targetY - 1), this.waterMimicEntity.getZ()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.obstructed = true;
                    return;
                }
                this.waterMimicEntity.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, this.speedModifier);
            }
        }

        public void start() {
            this.waterMimicEntity.setSwimmingUp(true);
            this.obstructed = false;
        }

        public void stop() {
            this.waterMimicEntity.setSwimmingUp(false);
        }
    }
}

