/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.init;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class MimicLootHandler {
    private static final HashMap<ResourceKey<Level>, ArrayList<ResourceLocation>> DIMENSIONAL_TABLES = new HashMap();
    private static final ArrayList<ResourceLocation> WATER_LOOT_TABLES = new ArrayList();

    public static void addWaterTable(ResourceLocation lootTable) {
        if (!WATER_LOOT_TABLES.contains(lootTable)) {
            WATER_LOOT_TABLES.add(lootTable);
        }
    }

    public static void addWaterTable(ResourceKey<LootTable> resourceKey) {
        MimicLootHandler.addWaterTable(resourceKey.location());
    }

    public static void removeWaterTable(ResourceLocation lootTable) {
        WATER_LOOT_TABLES.remove(lootTable);
    }

    public static void addDimensionalTable(ResourceKey<Level> dimType, ResourceKey<LootTable> resourceKey) {
        MimicLootHandler.addDimensionalTable(dimType, resourceKey.location());
    }

    public static void addDimensionalTable(ResourceKey<Level> dimType, ResourceLocation lootTable) {
        if (DIMENSIONAL_TABLES.containsKey(dimType)) {
            ArrayList<ResourceLocation> tableList = DIMENSIONAL_TABLES.get(dimType);
            if (!tableList.contains(lootTable)) {
                tableList.add(lootTable);
                DIMENSIONAL_TABLES.put(dimType, tableList);
            }
        } else {
            ArrayList<ResourceLocation> tableList = new ArrayList<ResourceLocation>();
            tableList.add(lootTable);
            DIMENSIONAL_TABLES.put(dimType, tableList);
        }
    }

    public static ResourceKey<Level> getKeyFromLocation(ResourceLocation loc) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
    }

    public static void addDimensionalTable(ResourceLocation dimensionLocation, ResourceLocation lootTable) {
        MimicLootHandler.addDimensionalTable(MimicLootHandler.getKeyFromLocation(dimensionLocation), lootTable);
    }

    public static void removeDimensionalTable(ResourceKey<Level> dimType, ResourceLocation lootTable) {
        ArrayList<ResourceLocation> tableList;
        if (DIMENSIONAL_TABLES.containsKey(dimType) && (tableList = DIMENSIONAL_TABLES.get(dimType)).contains(lootTable)) {
            tableList.remove(lootTable);
            DIMENSIONAL_TABLES.put(dimType, tableList);
        }
    }

    public static void removeDimensionalTable(ResourceLocation dimensionID, ResourceLocation lootTable) {
        MimicLootHandler.removeDimensionalTable(MimicLootHandler.getKeyFromLocation(dimensionID), lootTable);
    }

    public static HashMap<ResourceKey<Level>, ArrayList<ResourceLocation>> getDimensionalTables() {
        return DIMENSIONAL_TABLES;
    }

    public static ArrayList<ResourceLocation> getDimensionTables(ResourceKey<Level> type) {
        if (DIMENSIONAL_TABLES.containsKey(type)) {
            return DIMENSIONAL_TABLES.get(type);
        }
        return new ArrayList<ResourceLocation>();
    }

    public static ArrayList<String> getStringDimensionTables(ResourceKey<Level> type) {
        ArrayList<String> stringTables = new ArrayList<String>();
        if (DIMENSIONAL_TABLES.containsKey(type)) {
            ArrayList tables = new ArrayList(DIMENSIONAL_TABLES.get(type));
            for (ResourceLocation table : tables) {
                stringTables.add(table.toString());
            }
            return stringTables;
        }
        return stringTables;
    }

    public static ArrayList<String> getStringDimensionTables(ResourceLocation dim) {
        return MimicLootHandler.getStringDimensionTables(MimicLootHandler.getKeyFromLocation(dim));
    }

    public static ArrayList<String> getStringWaterTables() {
        ArrayList<String> stringTables = new ArrayList<String>();
        ArrayList<ResourceLocation> tables = new ArrayList<ResourceLocation>(WATER_LOOT_TABLES);
        for (ResourceLocation table : tables) {
            stringTables.add(table.toString());
        }
        return stringTables;
    }

    static {
        DIMENSIONAL_TABLES.put((ResourceKey<Level>)Level.OVERWORLD, new ArrayList());
        DIMENSIONAL_TABLES.put((ResourceKey<Level>)Level.NETHER, new ArrayList());
        DIMENSIONAL_TABLES.put((ResourceKey<Level>)Level.END, new ArrayList());
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.NETHER, (ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.NETHER, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.NETHER, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_BRIDGE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.NETHER, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_OTHER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.NETHER, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_HOGLIN_STABLE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.END, (ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_WEAPONSMITH);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TOOLSMITH);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_ARMORER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_CARTOGRAPHER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_MASON);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SHEPHERD);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_BUTCHER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_FLETCHER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_FISHER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TANNERY);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TEMPLE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_DESERT_HOUSE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_PLAINS_HOUSE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TAIGA_HOUSE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SNOWY_HOUSE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SAVANNA_HOUSE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_LIBRARY);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CROSSING);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE_DISPENSER);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.IGLOO_CHEST);
        MimicLootHandler.addDimensionalTable((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.UNDERWATER_RUIN_SMALL);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.UNDERWATER_RUIN_BIG);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_MAP);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_SUPPLY);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE);
        MimicLootHandler.addWaterTable((ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST);
    }
}

