/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.sfl.datagen;

import com.mrbysco.sfl.init.MimicRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SFLBiomeModifiers {
    protected static final ResourceKey<BiomeModifier> ADD_MIMIC = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sfl", (String)"add_mimic"));
    protected static final ResourceKey<BiomeModifier> ADD_NETHER_MIMIC = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sfl", (String)"add_nether_mimic"));
    protected static final ResourceKey<BiomeModifier> ADD_END_MIMIC = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sfl", (String)"add_end_mimic"));
    protected static final ResourceKey<BiomeModifier> ADD_WATER_MIMIC = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sfl", (String)"add_water_mimic"));

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderSet.Named isOverworld = biomeGetter.getOrThrow(Tags.Biomes.IS_OVERWORLD);
        HolderSet.Named isNether = biomeGetter.getOrThrow(Tags.Biomes.IS_NETHER);
        HolderSet.Named isEnd = biomeGetter.getOrThrow(Tags.Biomes.IS_END);
        HolderSet.Named isWater = biomeGetter.getOrThrow(Tags.Biomes.IS_WET_OVERWORLD);
        context.register(ADD_MIMIC, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)isOverworld, (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(MimicRegistry.MIMIC.get(), 1, 1), 1)));
        context.register(ADD_NETHER_MIMIC, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)isNether, (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(MimicRegistry.NETHER_MIMIC.get(), 1, 1), 1)));
        context.register(ADD_END_MIMIC, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)isEnd, (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(MimicRegistry.END_MIMIC.get(), 1, 1), 1)));
        context.register(ADD_WATER_MIMIC, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)isWater, (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(MimicRegistry.WATER_MIMIC.get(), 1, 1), 1)));
    }
}

