/*
 * Decompiled with CFR 0.152.
 */
package com.mod.windlaunch;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindLaunchMod
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"WindLaunch");
    private static class_304 launchKey;
    private static class_304 switchToMaceKey;
    private static class_304 autoMoveKey;
    private boolean switchToMaceEnabled = true;
    private boolean autoMoveEnabled = true;
    private String priorityMessage = null;
    private boolean multiplayerAllowed = false;
    private static final byte MSG_HELLO = 1;
    private static final byte MSG_OK = 2;
    private static final byte MSG_DENY = 3;
    private static final class_2960 HANDSHAKE_ID_RAW;
    private static final class_8710.class_9154<HandshakePayload> HANDSHAKE_ID;
    private int handshakeDelayTicks = -1;
    private int handshakeAttempts = 0;

    public void onInitializeClient() {
        LOGGER.info("Client initializing WindLaunch");
        class_304.class_11900 windLaunchCategory = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"windlaunch", (String)"main"));
        launchKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.windlaunch.launch", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), windLaunchCategory));
        switchToMaceKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.windlaunch.switchtomace", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), windLaunchCategory));
        autoMoveKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.windlaunch.automove", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), windLaunchCategory));
        PayloadTypeRegistry.playC2S().register(HANDSHAKE_ID, HandshakePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(HANDSHAKE_ID, HandshakePayload.CODEC);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            boolean isSingleplayer;
            this.multiplayerAllowed = isSingleplayer = client.method_1496();
            if (isSingleplayer) {
                LOGGER.info("Singleplayer detected: WindLaunch enabled");
                this.sendActionBarMessage(client, "\u00a7aWindLaunch active (singleplayer)");
            } else {
                LOGGER.info("Multiplayer detected: scheduling handshake...");
                this.sendActionBarMessage(client, "\u00a7eWindLaunch checking server...");
                this.handshakeDelayTicks = 40;
                this.handshakeAttempts = 0;
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.multiplayerAllowed = false;
            LOGGER.info("Disconnected: WindLaunch disabled");
            this.sendActionBarMessage(client, "\u00a7cWindLaunch disabled");
        });
        ClientPlayNetworking.registerGlobalReceiver(HANDSHAKE_ID, (payload, context) -> {
            byte code = payload.code();
            context.client().execute(() -> {
                LOGGER.info("Received handshake code {}", (Object)code);
                if (code == 2) {
                    this.multiplayerAllowed = true;
                    LOGGER.info("Handshake OK: WindLaunch enabled");
                    this.sendActionBarMessage(context.client(), "\u00a7aWindLaunch enabled by server");
                } else if (code == 3) {
                    this.multiplayerAllowed = false;
                    LOGGER.info("Handshake DENY: WindLaunch disabled");
                    this.sendActionBarMessage(context.client(), "\u00a7cWindLaunch disabled by server");
                }
            });
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            if (this.handshakeDelayTicks > 0) {
                --this.handshakeDelayTicks;
            } else if (this.handshakeDelayTicks == 0 && this.handshakeAttempts < 5 && !this.multiplayerAllowed) {
                ClientPlayNetworking.send((class_8710)new HandshakePayload(1));
                LOGGER.info("Sent handshake HELLO (attempt {})", (Object)(this.handshakeAttempts + 1));
                ++this.handshakeAttempts;
                this.handshakeDelayTicks = 40;
            }
            while (launchKey.method_1436()) {
                this.launchWindCharge(client);
            }
            while (switchToMaceKey.method_1436()) {
                this.toggleSwitchToMace(client);
            }
            while (autoMoveKey.method_1436()) {
                this.toggleAutoMove(client);
            }
            if (this.priorityMessage != null) {
                this.sendActionBarMessage(client, this.priorityMessage);
                this.priorityMessage = null;
            }
        });
    }

    private void launchWindCharge(class_310 client) {
        if (client.field_1724 != null) {
            if (!this.isModAllowed(client)) {
                this.sendActionBarMessage(client, "\u00a7cWindLaunch blocked by server");
                LOGGER.info("Action blocked: WindLaunch disabled by server");
                return;
            }
            int windChargeSlot = -1;
            int maceSlot = -1;
            for (int i = 0; i < 9; ++i) {
                class_1799 stack = client.field_1724.method_31548().method_5438(i);
                if (stack.method_7909() == class_1802.field_49098) {
                    windChargeSlot = i;
                    continue;
                }
                if (stack.method_7909() != class_1802.field_49814) continue;
                maceSlot = i;
            }
            if (windChargeSlot != -1) {
                LOGGER.info("Launching wind charge from slot {}", (Object)windChargeSlot);
                client.field_1724.method_31548().method_61496(windChargeSlot);
                float pitch = client.field_1724.method_36455();
                client.field_1724.method_36457(90.0f);
                client.field_1724.method_6043();
                if (client.field_1761 != null) {
                    client.field_1761.method_2919((class_1657)client.field_1724, class_1268.field_5808);
                }
                client.field_1724.method_36457(pitch);
                if (this.switchToMaceEnabled && maceSlot != -1) {
                    client.field_1724.method_31548().method_61496(maceSlot);
                }
                if (this.autoMoveEnabled) {
                    this.moveOneWindCharge(client, windChargeSlot);
                }
                this.checkWindChargeInventory(client);
                this.sendActionBarMessage(client, "\u00a7bLaunched wind charge");
            } else {
                this.setPriorityMessage("\u00a7cNo wind charge found in hotbar");
                LOGGER.info("No wind charge found in hotbar");
            }
        }
    }

    private void toggleSwitchToMace(class_310 client) {
        this.switchToMaceEnabled = !this.switchToMaceEnabled;
        this.sendActionBarMessage(client, this.switchToMaceEnabled ? "\u00a7aMace switching enabled" : "\u00a7cMace switching disabled");
        LOGGER.info("Mace switching {}", (Object)(this.switchToMaceEnabled ? "enabled" : "disabled"));
    }

    private void toggleAutoMove(class_310 client) {
        this.autoMoveEnabled = !this.autoMoveEnabled;
        this.sendActionBarMessage(client, this.autoMoveEnabled ? "\u00a7aAuto move enabled" : "\u00a7cAuto move disabled");
        LOGGER.info("Auto move {}", (Object)(this.autoMoveEnabled ? "enabled" : "disabled"));
    }

    private void moveOneWindCharge(class_310 client, int targetSlot) {
        if (client.field_1724 == null || client.field_1761 == null) {
            return;
        }
        int invSlot = -1;
        for (int i = 9; i < 36; ++i) {
            if (client.field_1724.method_31548().method_5438(i).method_7909() != class_1802.field_49098) continue;
            invSlot = i;
            break;
        }
        if (invSlot == -1) {
            return;
        }
        class_1799 targetStack = client.field_1724.method_31548().method_5438(targetSlot);
        if (targetStack.method_7960() || targetStack.method_7909() == class_1802.field_49098 && targetStack.method_7947() < targetStack.method_7914()) {
            client.field_1761.method_2906(client.field_1724.field_7498.field_7763, invSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
            client.field_1761.method_2906(client.field_1724.field_7498.field_7763, targetSlot < 9 ? 36 + targetSlot : targetSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
            if (!client.field_1724.field_7512.method_34255().method_7960()) {
                client.field_1761.method_2906(client.field_1724.field_7498.field_7763, invSlot, 0, class_1713.field_7790, (class_1657)client.field_1724);
            }
        }
    }

    private void checkWindChargeInventory(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        int total = 0;
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = client.field_1724.method_31548().method_5438(i);
            if (stack.method_7909() != class_1802.field_49098) continue;
            total += stack.method_7947();
        }
        if (total <= 32) {
            this.setPriorityMessage("\u00a7eLow on wind charges: " + total + " left");
        }
    }

    private void sendActionBarMessage(class_310 client, String message) {
        if (client.field_1724 != null && client.field_1687 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1070), true);
        }
    }

    private void setPriorityMessage(String message) {
        if (this.priorityMessage == null) {
            this.priorityMessage = message;
        }
    }

    private boolean isModAllowed(class_310 client) {
        boolean singleplayer = client.method_1496();
        return singleplayer || this.multiplayerAllowed;
    }

    static {
        HANDSHAKE_ID_RAW = class_2960.method_60655((String)"windlaunch", (String)"handshake");
        HANDSHAKE_ID = new class_8710.class_9154(HANDSHAKE_ID_RAW);
    }

    public record HandshakePayload(byte code) implements class_8710
    {
        public static final class_9139<class_9129, HandshakePayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_52997((int)payload.code()), buf -> new HandshakePayload(buf.readByte()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return HANDSHAKE_ID;
        }
    }
}

