/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lexdragons.init;

import net.mcreator.lexdragons.entity.AlbinoDragonEntity;
import net.mcreator.lexdragons.entity.AmethystProjectileEntity;
import net.mcreator.lexdragons.entity.AmethystWyvernEntity;
import net.mcreator.lexdragons.entity.HornedDragonEntity;
import net.mcreator.lexdragons.entity.IceWyvernEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LexdragonsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"lexdragons");
    public static final DeferredHolder<EntityType<?>, EntityType<HornedDragonEntity>> HORNED_DRAGON = LexdragonsModEntities.register("horned_dragon", EntityType.Builder.of(HornedDragonEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AlbinoDragonEntity>> ALBINO_DRAGON = LexdragonsModEntities.register("albino_dragon", EntityType.Builder.of(AlbinoDragonEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.5f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<IceWyvernEntity>> ICE_WYVERN = LexdragonsModEntities.register("ice_wyvern", EntityType.Builder.of(IceWyvernEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AmethystWyvernEntity>> AMETHYST_WYVERN = LexdragonsModEntities.register("amethyst_wyvern", EntityType.Builder.of(AmethystWyvernEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<AmethystProjectileEntity>> AMETHYST_PROJECTILE = LexdragonsModEntities.register("amethyst_projectile", EntityType.Builder.of(AmethystProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.3f, 0.3f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)HORNED_DRAGON.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)ALBINO_DRAGON.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)ICE_WYVERN.get(), (living, context) -> living.getInventory());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)AMETHYST_WYVERN.get(), (living, context) -> living.getInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        HornedDragonEntity.init(event);
        AlbinoDragonEntity.init(event);
        IceWyvernEntity.init(event);
        AmethystWyvernEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HORNED_DRAGON.get(), HornedDragonEntity.createAttributes().build());
        event.put((EntityType)ALBINO_DRAGON.get(), AlbinoDragonEntity.createAttributes().build());
        event.put((EntityType)ICE_WYVERN.get(), IceWyvernEntity.createAttributes().build());
        event.put((EntityType)AMETHYST_WYVERN.get(), AmethystWyvernEntity.createAttributes().build());
    }
}

