/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.dataclasses.ConfigEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.architectury.platform.Platform;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("axislock.json");
    private final Map<String, ConfigEntry<?>> configEntries = new HashMap();
    private Map<String, Object> configValues = new HashMap<String, Object>();
    private static ConfigManager INSTANCE;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigManager();
        }
        return INSTANCE;
    }

    public void registerConfig(ConfigEntry<?> entry) {
        this.configEntries.put(entry.getId(), entry);
    }

    public <T> T getValue(String id, Class<T> type) {
        if (!this.configValues.containsKey(id) && this.configEntries.containsKey(id)) {
            return type.cast(this.configEntries.get(id).getDefaultValue());
        }
        return type.cast(this.configValues.get(id));
    }

    public <T> void setValue(String id, T value) {
        this.configValues.put(id, value);
    }

    public void load() {
        block8: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                        this.configValues = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(this){}.getType());
                        break block8;
                    }
                }
                this.configEntries.forEach((id, entry) -> this.configValues.put((String)id, entry.getDefaultValue()));
                this.save();
            }
            catch (IOException e) {
                System.err.println("Error al cargar la configuraci\u00f3n: " + e.getMessage());
            }
        }
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson(this.configValues, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Error al guardar la configuraci\u00f3n: " + e.getMessage());
        }
    }
}

