/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;

public class BlockCheck {
    public static BlockPos firstBlockInSequence = null;

    public static void init() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register(BlockCheck::onBlockPlaceAttempt);
        InteractionEvent.LEFT_CLICK_BLOCK.register((player, hand, pos, direction) -> BlockCheck.onBlockBreakAttempt(player, pos));
    }

    public static void onClientTick(Minecraft client) {
        if (client.player == null || client.level == null) {
            return;
        }
        switch (Axislock.config.general.current_mode) {
            case PLACEMENT: {
                if (client.options.keyUse.isDown()) break;
                firstBlockInSequence = null;
                break;
            }
            case BREAKING: {
                if (client.options.keyAttack.isDown()) break;
                firstBlockInSequence = null;
                break;
            }
            case BOTH: {
                if (client.options.keyUse.isDown() || client.options.keyAttack.isDown()) break;
                firstBlockInSequence = null;
            }
        }
    }

    public static InteractionResult onBlockBreakAttempt(Player player, BlockPos blockPos) {
        if (Axislock.config.general.current_mode == AxislockMode.PLACEMENT) {
            return InteractionResult.PASS;
        }
        return BlockCheck.blockCheck(player, player.level(), blockPos);
    }

    public static InteractionResult onBlockPlaceAttempt(Player player, InteractionHand hand, BlockPos blockPos, Direction direction) {
        if (Axislock.config.general.current_mode == AxislockMode.BREAKING) {
            return InteractionResult.PASS;
        }
        if (!(player.getItemInHand(hand).getItem() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        if (!player.level().getBlockState(blockPos.relative(direction)).isAir()) {
            return InteractionResult.PASS;
        }
        return BlockCheck.blockCheck(player, player.level(), blockPos.relative(direction));
    }

    public static InteractionResult blockCheck(Player player, Level world, BlockPos targetBlockPos) {
        BlockPos referencePosForCheck;
        if (!world.isClientSide() || !Axislock.config.general.mod_enabled || player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (Axislock.config.general.manual_reference_point.toBlockPos() != null) {
            referencePosForCheck = Axislock.config.general.manual_reference_point.toBlockPos();
        } else {
            if (firstBlockInSequence == null) {
                firstBlockInSequence = targetBlockPos;
                return InteractionResult.PASS;
            }
            referencePosForCheck = firstBlockInSequence;
        }
        boolean allowPlacement = switch (Axislock.config.general.current_axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (targetBlockPos.getX() == referencePosForCheck.getX()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (targetBlockPos.getY() == referencePosForCheck.getY()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> targetBlockPos.getZ() == referencePosForCheck.getZ();
        };
        return allowPlacement ? InteractionResult.PASS : InteractionResult.FAIL;
    }
}

