/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.config.ConfigManager;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class HUDRenderer {
    private static final float BASE_SCALE = 0.7f;
    private static final float SCALE_DIVISOR = 50.0f;
    private static final int BACKGROUND_PADDING = 1;
    private static final int DEFAULT_SIZE = 50;
    private static final int DEFAULT_POSITION = 5;

    public static void init() {
        ClientGuiEvent.RENDER_HUD.register(HUDRenderer::renderHud);
    }

    private static void renderHud(GuiGraphics context, DeltaTracker renderTickCounter) {
        if (!HUDRenderer.shouldRenderHud()) {
            return;
        }
        BlockPos referencePoint = HUDRenderer.getReferencePoint();
        if (referencePoint == null) {
            return;
        }
        HUDRenderer.renderHudContent(context, referencePoint);
    }

    private static boolean shouldRenderHud() {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.level == null || !client.player.isAlive()) {
            return false;
        }
        return Axislock.config.general.mod_enabled && Axislock.config.hud.enabled;
    }

    private static BlockPos getReferencePoint() {
        BlockPos manualReferencePoint = Axislock.config.general.manual_reference_point.toBlockPos();
        return manualReferencePoint != null ? manualReferencePoint : BlockCheck.firstBlockInSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderHudContent(GuiGraphics context, BlockPos referencePoint) {
        context.pose().pushMatrix();
        try {
            float scale = HUDRenderer.calculateScale();
            context.pose().scale(scale, scale);
            String displayText = HUDRenderer.buildDisplayText(referencePoint);
            HUDRenderer.renderTextWithBackground(context, displayText);
        }
        finally {
            context.pose().popMatrix();
        }
    }

    private static float calculateScale() {
        if (Axislock.config.hud.size < 0 || Axislock.config.hud.size > 100) {
            Axislock.config.hud.size = 50;
            Axislock.LOGGER.warn("Invalid HUD size: {}. Using default value: {}", (Object)Axislock.config.hud.size, (Object)50);
            ConfigManager.save();
        }
        return 0.7f * (float)Axislock.config.hud.size / 50.0f;
    }

    private static String buildDisplayText(BlockPos referencePoint) {
        String coordinate = HUDRenderer.getCoordinateText(referencePoint);
        String lockText = HUDRenderer.getLockModeText();
        return lockText + " " + coordinate;
    }

    private static String getCoordinateText(BlockPos referencePoint) {
        return switch (Axislock.config.general.current_axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> "X= " + referencePoint.getX();
            case Axis.Y -> "Y= " + referencePoint.getY();
            case Axis.Z -> "Z= " + referencePoint.getZ();
        };
    }

    private static String getLockModeText() {
        return switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> Component.translatable((String)"axislock.place").getString();
            case AxislockMode.BREAKING -> Component.translatable((String)"axislock.break").getString();
            case AxislockMode.BOTH -> Component.translatable((String)"axislock.both").getString();
        };
    }

    private static void renderTextWithBackground(GuiGraphics context, String text) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width(text);
        Objects.requireNonNull(font);
        int textHeight = 9;
        HUDRenderer.renderBackground(context, textWidth, textHeight);
        HUDRenderer.renderText(context, font, text);
    }

    private static void renderBackground(GuiGraphics context, int textWidth, int textHeight) {
        int x = HUDRenderer.calculatePosition(true);
        int y = HUDRenderer.calculatePosition(false);
        context.fill(x - 1, y - 1, x + textWidth + 1, y + textHeight + 1, Axislock.config.hud.background_color.toHex());
    }

    private static void renderText(GuiGraphics context, Font font, String text) {
        int color = Axislock.config.hud.color.toHex();
        int x = HUDRenderer.calculatePosition(true);
        int y = HUDRenderer.calculatePosition(false);
        context.drawString(font, text, x, y, color, Axislock.config.hud.shadow);
    }

    private static int calculatePosition(boolean getWidth) {
        int screenSize;
        int position;
        Minecraft client = Minecraft.getInstance();
        if (getWidth) {
            position = Axislock.config.hud.position.x;
            screenSize = client.getWindow().getGuiScaledWidth();
        } else {
            position = Axislock.config.hud.position.y;
            screenSize = client.getWindow().getGuiScaledHeight();
        }
        if (position < 0 || position > 100) {
            position = 5;
            Axislock.config.hud.position.x = 5;
            Axislock.config.hud.position.y = 5;
            Axislock.LOGGER.warn("Invalid HUD position: {}. Using default value: {}", (Object)position, (Object)5);
            ConfigManager.save();
        }
        return (int)((float)screenSize * ((float)position / 100.0f) * 50.0f / (float)Axislock.config.hud.size * 1.4285715f);
    }
}

