/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.BlockHitResult;

public class InputManager {
    private static KeyMapping toggleModKey;
    private static KeyMapping holdAxisLockKey;
    private static KeyMapping cycleAxisKey;
    private static KeyMapping cycleModeKey;
    private static KeyMapping ReferencePointKey;
    private static KeyMapping selectAxisXKey;
    private static KeyMapping selectAxisYKey;
    private static KeyMapping selectAxisZKey;
    private static boolean holdAxisKeyActive;
    private static final int DOUBLE_PRESS_THRESHOLD = 8;
    private static long lastReferencePointPressTime;

    public static void registerKeys() {
        toggleModKey = new KeyMapping("key.axislock.toggle", InputConstants.Type.KEYSYM, 82, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)toggleModKey);
        holdAxisLockKey = new KeyMapping("key.axislock.hold", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)holdAxisLockKey);
        cycleAxisKey = new KeyMapping("key.axislock.cycle_axis", InputConstants.Type.KEYSYM, 89, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)cycleAxisKey);
        cycleModeKey = new KeyMapping("key.axislock.cycle_mode", InputConstants.Type.KEYSYM, 78, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)cycleModeKey);
        ReferencePointKey = new KeyMapping("key.axislock.set_reference_point", InputConstants.Type.KEYSYM, 66, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)ReferencePointKey);
        selectAxisXKey = new KeyMapping("key.axislock.select_x", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisXKey);
        selectAxisYKey = new KeyMapping("key.axislock.select_y", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisYKey);
        selectAxisZKey = new KeyMapping("key.axislock.select_z", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisZKey);
    }

    public static void inputManager(Minecraft client) {
        if (client.player == null || client.level == null) {
            return;
        }
        InputManager.updateHoldAxisKey(client);
        InputManager.toggleMod(client);
        boolean bl = Axislock.config.general.mod_enabled = Axislock.config.general.mod_enabled || holdAxisKeyActive;
        if (!Axislock.config.general.mod_enabled) {
            BlockCheck.firstBlockInSequence = null;
        }
        InputManager.updateAxis(client);
        InputManager.handleReferencePointKey(client);
        InputManager.cycleMod(client);
    }

    private static void handleReferencePointKey(Minecraft client) {
        BlockHitResult hitResult;
        if (!ReferencePointKey.consumeClick()) {
            return;
        }
        if (InputManager.isDoublePress() && Axislock.config.general.manual_reference_point.toBlockPos() != null) {
            Axislock.config.general.manual_reference_point.reset(false);
            BlockCheck.firstBlockInSequence = null;
            InputManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.reset").getString(), ChatFormatting.YELLOW);
            return;
        }
        BlockHitResult blockHitResult = hitResult = client.hitResult instanceof BlockHitResult ? (BlockHitResult)client.hitResult : null;
        if (client.level == null || client.player == null || hitResult == null) {
            return;
        }
        if (!client.level.getBlockState(hitResult.getBlockPos()).isAir()) {
            Axislock.config.general.manual_reference_point.fromBlockPos(hitResult.getBlockPos());
            BlockCheck.firstBlockInSequence = null;
            InputManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.set", (Object[])new Object[]{hitResult.getBlockPos().toShortString()}).getString(), ChatFormatting.YELLOW);
        } else {
            BlockCheck.firstBlockInSequence = null;
            Axislock.config.general.manual_reference_point.reset(false);
            InputManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.reset").getString(), ChatFormatting.YELLOW);
        }
    }

    private static boolean isDoublePress() {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return false;
        }
        if (lastReferencePointPressTime == -1L) {
            lastReferencePointPressTime = client.player.tickCount;
            return false;
        }
        boolean isDoublePress = (long)client.player.tickCount - lastReferencePointPressTime < 8L;
        lastReferencePointPressTime = isDoublePress ? -1L : (long)client.player.tickCount;
        return isDoublePress;
    }

    private static void updateAxis(Minecraft client) {
        Axis PreviousSelectedAxis = Axislock.config.general.current_axis;
        while (cycleAxisKey.consumeClick()) {
            Axislock.config.general.current_axis = Axislock.config.general.current_axis.next();
        }
        if (selectAxisXKey.consumeClick()) {
            Axislock.config.general.current_axis = Axis.X;
        } else if (selectAxisYKey.consumeClick()) {
            Axislock.config.general.current_axis = Axis.Y;
        } else if (selectAxisZKey.consumeClick()) {
            Axislock.config.general.current_axis = Axis.Z;
        }
        if (PreviousSelectedAxis != Axislock.config.general.current_axis) {
            BlockCheck.firstBlockInSequence = null;
            String message = Component.translatable((String)"axislock.select", (Object[])new Object[]{Axislock.config.general.current_axis.toString()}).getString();
            InputManager.sendMessage(client, message, ChatFormatting.WHITE);
        }
    }

    private static void updateHoldAxisKey(Minecraft client) {
        ChatFormatting formatting;
        boolean previousHoldState = holdAxisKeyActive;
        holdAxisKeyActive = Axislock.config.extra.key_axislock_hold_is_normally_open ? holdAxisLockKey.isDown() : !holdAxisLockKey.isDown();
        String message = holdAxisKeyActive ? Component.translatable((String)"axislock.hold.enabled").getString() : Component.translatable((String)"axislock.hold.disabled").getString();
        ChatFormatting chatFormatting = formatting = holdAxisKeyActive ? ChatFormatting.GREEN : ChatFormatting.RED;
        if (holdAxisKeyActive && !previousHoldState) {
            InputManager.sendMessage(client, message.formatted(new Object[]{Axislock.config.general.current_axis}), formatting);
        }
    }

    private static void toggleMod(Minecraft client) {
        if (toggleModKey.consumeClick()) {
            if (!holdAxisKeyActive) {
                Axislock.config.general.mod_enabled = !Axislock.config.general.mod_enabled;
                String message = Axislock.config.general.mod_enabled ? Component.translatable((String)"axislock.toggle.enabled").getString() : Component.translatable((String)"axislock.toggle.disabled").getString();
                ChatFormatting formatting = Axislock.config.general.mod_enabled ? ChatFormatting.GREEN : ChatFormatting.RED;
                InputManager.sendMessage(client, message.formatted(new Object[]{Axislock.config.general.current_axis}), formatting);
            } else {
                InputManager.sendMessage(client, Component.translatable((String)"axislock.toggle.ignored").getString(), ChatFormatting.YELLOW);
            }
        }
    }

    private static void cycleMod(Minecraft client) {
        boolean modeChanged = false;
        while (cycleModeKey.consumeClick()) {
            Axislock.config.general.current_mode = Axislock.config.general.current_mode.next();
            modeChanged = true;
        }
        if (!modeChanged) {
            return;
        }
        String modeMessage = switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> Component.translatable((String)"axislock.mode.changed.placement").getString();
            case AxislockMode.BREAKING -> Component.translatable((String)"axislock.mode.changed.breaking").getString();
            case AxislockMode.BOTH -> Component.translatable((String)"axislock.mode.changed.placement_and_breaking").getString();
        };
        InputManager.sendMessage(client, modeMessage, ChatFormatting.YELLOW);
    }

    private static void sendMessage(Minecraft client, String message, ChatFormatting formatting) {
        if (client.player == null || client.level == null) {
            return;
        }
        if (formatting == null) {
            formatting = ChatFormatting.WHITE;
        }
        client.player.displayClientMessage((Component)Component.literal((String)message).withStyle(formatting), true);
    }

    static {
        holdAxisKeyActive = false;
        lastReferencePointPressTime = -1L;
    }
}

