/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock.config;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.core.BlockPos;

@Config(name="axislock")
public class AxislockConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.TransitiveObject
    public GeneralConfig general = new GeneralConfig();
    @ConfigEntry.Category(value="hud")
    @ConfigEntry.Gui.TransitiveObject
    public HUDConfig hud = new HUDConfig();
    @ConfigEntry.Category(value="extra")
    @ConfigEntry.Gui.TransitiveObject
    public ExtraConfig extra = new ExtraConfig();

    public static void register() {
        AutoConfig.register(AxislockConfig.class, Toml4jConfigSerializer::new);
    }

    public static class GeneralConfig {
        public boolean mod_enabled = false;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public AxislockMode current_mode = AxislockMode.PLACEMENT;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Axis current_axis = Axis.Y;
        public boolean use_manual_reference_point = false;
        @ConfigEntry.Gui.CollapsibleObject
        public BlockPosition manual_reference_point = new BlockPosition();

        public static class BlockPosition {
            public int x = 0;
            public int y = 0;
            public int z = 0;

            public BlockPos toBlockPos() {
                if (!Axislock.config.general.use_manual_reference_point) {
                    return null;
                }
                return new BlockPos(this.x, this.y, this.z);
            }

            public void fromBlockPos(BlockPos pos) {
                Axislock.config.general.use_manual_reference_point = true;
                if (pos != null) {
                    this.x = pos.getX();
                    this.y = pos.getY();
                    this.z = pos.getZ();
                }
            }

            public void reset(boolean keepLocation) {
                if (!keepLocation) {
                    this.x = 0;
                    this.y = 0;
                    this.z = 0;
                }
                Axislock.config.general.use_manual_reference_point = false;
            }
        }
    }

    public static class HUDConfig {
        public boolean enabled = true;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int size = 50;
        @ConfigEntry.Gui.CollapsibleObject
        public Position position = new Position();
        @ConfigEntry.Gui.CollapsibleObject
        public Color color = new Color().fromHex(-587202561);
        @ConfigEntry.Gui.CollapsibleObject
        public Color background_color = new Color().fromHex(0);
        public boolean shadow = true;

        public static class Position {
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int x = 70;
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int y = 1;
        }

        public static class Color {
            @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
            public int red = 0;
            @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
            public int green = 0;
            @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
            public int blue = 0;
            @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
            public int opacity = 255;

            public int toHex() {
                return this.opacity << 24 | this.red << 16 | this.green << 8 | this.blue;
            }

            public Color fromHex(int hex) {
                this.opacity = hex >>> 24 & 0xFF;
                this.red = hex >>> 16 & 0xFF;
                this.green = hex >>> 8 & 0xFF;
                this.blue = hex & 0xFF;
                return this;
            }
        }
    }

    public static class ExtraConfig {
        public boolean key_axislock_hold_is_normally_open = true;
    }
}

