/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock.config;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.config.AxislockConfig;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;

public class ConfigManager {
    public static void start() {
        try {
            AxislockConfig.register();
            ConfigHolder holder = AutoConfig.getConfigHolder(AxislockConfig.class);
            Axislock.config = (AxislockConfig)holder.getConfig();
            ConfigManager.setupConfigListeners((ConfigHolder<AxislockConfig>)holder);
        }
        catch (RuntimeException e) {
            Axislock.LOGGER.warn("Error loading configuration: {}", (Object)e.getMessage());
            ConfigManager.deleteConfigFile();
            try {
                AxislockConfig.register();
                ConfigHolder holder = AutoConfig.getConfigHolder(AxislockConfig.class);
                Axislock.config = (AxislockConfig)holder.getConfig();
                ConfigManager.setupConfigListeners((ConfigHolder<AxislockConfig>)holder);
            }
            catch (Exception retryException) {
                Axislock.LOGGER.error("Critical error creating new configuration", (Throwable)retryException);
                Axislock.config = new AxislockConfig();
            }
        }
    }

    public static void save() {
        try {
            ConfigHolder holder = AutoConfig.getConfigHolder(AxislockConfig.class);
            holder.setConfig((ConfigData)Axislock.config);
            holder.save();
        }
        catch (Exception e) {
            Axislock.LOGGER.error("Error saving AxisLock configuration", (Throwable)e);
        }
    }

    private static void setupConfigListeners(ConfigHolder<AxislockConfig> holder) {
        holder.registerSaveListener((configHolder, newConfig) -> {
            Axislock.config = newConfig;
            return EventResult.pass().asMinecraft();
        });
        holder.registerLoadListener((configHolder, loadedConfig) -> {
            configHolder.setConfig((ConfigData)Axislock.config);
            Axislock.config = loadedConfig;
            return EventResult.pass().asMinecraft();
        });
        ClientLifecycleEvent.CLIENT_STOPPING.register(client -> {
            try {
                holder.setConfig((ConfigData)Axislock.config);
                holder.save();
            }
            catch (Exception e) {
                Axislock.LOGGER.error("Error saving AxisLock configuration", (Throwable)e);
            }
        });
    }

    private static void deleteConfigFile() {
        try {
            Path configPath = Paths.get(System.getProperty("user.dir"), "config").resolve("axislock.toml");
            if (Files.exists(configPath, new LinkOption[0])) {
                Path backupPath = configPath.getParent().resolve("axislock_Old.toml");
                if (Files.exists(backupPath, new LinkOption[0])) {
                    Files.delete(backupPath);
                    Axislock.LOGGER.info("Existing backup configuration deleted: {}", (Object)backupPath);
                }
                Files.move(configPath, backupPath, new CopyOption[0]);
                Axislock.LOGGER.info("Corrupted configuration backed up to: {}", (Object)backupPath);
            }
        }
        catch (Exception e) {
            Axislock.LOGGER.error("Could not backup configuration file", (Throwable)e);
        }
    }
}

