/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.config.ConfigManager;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class HUDRenderer {
    private static final float BASE_SCALE = 0.7f;
    private static final float SCALE_DIVISOR = 50.0f;
    private static final int BACKGROUND_PADDING = 1;
    private static final int DEFAULT_SIZE = 50;
    private static final int DEFAULT_POSITION = 5;

    public static void init() {
        ClientGuiEvent.RENDER_HUD.register(HUDRenderer::renderHud);
    }

    private static void renderHud(class_332 context, class_9779 renderTickCounter) {
        if (!HUDRenderer.shouldRenderHud()) {
            return;
        }
        class_2338 referencePoint = HUDRenderer.getReferencePoint();
        if (referencePoint == null) {
            return;
        }
        HUDRenderer.renderHudContent(context, referencePoint);
    }

    private static boolean shouldRenderHud() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || !client.field_1724.method_5805()) {
            return false;
        }
        return Axislock.config.general.mod_enabled && Axislock.config.hud.enabled;
    }

    private static class_2338 getReferencePoint() {
        class_2338 manualReferencePoint = Axislock.config.general.manual_reference_point.toBlockPos();
        return manualReferencePoint != null ? manualReferencePoint : BlockCheck.firstBlockInSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderHudContent(class_332 context, class_2338 referencePoint) {
        context.method_51448().pushMatrix();
        try {
            float scale = HUDRenderer.calculateScale();
            context.method_51448().scale(scale, scale);
            String displayText = HUDRenderer.buildDisplayText(referencePoint);
            HUDRenderer.renderTextWithBackground(context, displayText);
        }
        finally {
            context.method_51448().popMatrix();
        }
    }

    private static float calculateScale() {
        if (Axislock.config.hud.size < 0 || Axislock.config.hud.size > 100) {
            Axislock.config.hud.size = 50;
            Axislock.LOGGER.warn("Invalid HUD size: {}. Using default value: {}", (Object)Axislock.config.hud.size, (Object)50);
            ConfigManager.save();
        }
        return 0.7f * (float)Axislock.config.hud.size / 50.0f;
    }

    private static String buildDisplayText(class_2338 referencePoint) {
        String coordinate = HUDRenderer.getCoordinateText(referencePoint);
        String lockText = HUDRenderer.getLockModeText();
        return lockText + " " + coordinate;
    }

    private static String getCoordinateText(class_2338 referencePoint) {
        return switch (Axislock.config.general.current_axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> "X= " + referencePoint.method_10263();
            case Axis.Y -> "Y= " + referencePoint.method_10264();
            case Axis.Z -> "Z= " + referencePoint.method_10260();
        };
    }

    private static String getLockModeText() {
        return switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> class_2561.method_43471((String)"axislock.place").getString();
            case AxislockMode.BREAKING -> class_2561.method_43471((String)"axislock.break").getString();
            case AxislockMode.BOTH -> class_2561.method_43471((String)"axislock.both").getString();
        };
    }

    private static void renderTextWithBackground(class_332 context, String text) {
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        Objects.requireNonNull(font);
        int textHeight = 9;
        HUDRenderer.renderBackground(context, textWidth, textHeight);
        HUDRenderer.renderText(context, font, text);
    }

    private static void renderBackground(class_332 context, int textWidth, int textHeight) {
        int x = HUDRenderer.calculatePosition(true);
        int y = HUDRenderer.calculatePosition(false);
        context.method_25294(x - 1, y - 1, x + textWidth + 1, y + textHeight + 1, Axislock.config.hud.background_color.toHex());
    }

    private static void renderText(class_332 context, class_327 font, String text) {
        int color = Axislock.config.hud.color.toHex();
        int x = HUDRenderer.calculatePosition(true);
        int y = HUDRenderer.calculatePosition(false);
        context.method_51433(font, text, x, y, color, Axislock.config.hud.shadow);
    }

    private static int calculatePosition(boolean getWidth) {
        int screenSize;
        int position;
        class_310 client = class_310.method_1551();
        if (getWidth) {
            position = Axislock.config.hud.position.x;
            screenSize = client.method_22683().method_4486();
        } else {
            position = Axislock.config.hud.position.y;
            screenSize = client.method_22683().method_4502();
        }
        if (position < 0 || position > 100) {
            position = 5;
            Axislock.config.hud.position.x = 5;
            Axislock.config.hud.position.y = 5;
            Axislock.LOGGER.warn("Invalid HUD position: {}. Using default value: {}", (Object)position, (Object)5);
            ConfigManager.save();
        }
        return (int)((float)screenSize * ((float)position / 100.0f) * 50.0f / (float)Axislock.config.hud.size * 1.4285715f);
    }
}

