/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;

public class InputManager {
    private static class_304 toggleModKey;
    private static class_304 holdAxisLockKey;
    private static class_304 cycleAxisKey;
    private static class_304 cycleModeKey;
    private static class_304 ReferencePointKey;
    private static class_304 selectAxisXKey;
    private static class_304 selectAxisYKey;
    private static class_304 selectAxisZKey;
    private static boolean holdAxisKeyActive;
    private static final int DOUBLE_PRESS_THRESHOLD = 8;
    private static long lastReferencePointPressTime;

    public static void registerKeys() {
        toggleModKey = new class_304("key.axislock.toggle", class_3675.class_307.field_1668, 82, "category.axislock.keys");
        KeyMappingRegistry.register((class_304)toggleModKey);
        holdAxisLockKey = new class_304("key.axislock.hold", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.axislock.keys");
        KeyMappingRegistry.register((class_304)holdAxisLockKey);
        cycleAxisKey = new class_304("key.axislock.cycle_axis", class_3675.class_307.field_1668, 89, "category.axislock.keys");
        KeyMappingRegistry.register((class_304)cycleAxisKey);
        cycleModeKey = new class_304("key.axislock.cycle_mode", class_3675.class_307.field_1668, 78, "category.axislock.keys");
        KeyMappingRegistry.register((class_304)cycleModeKey);
        ReferencePointKey = new class_304("key.axislock.set_reference_point", class_3675.class_307.field_1668, 66, "category.axislock.keys");
        KeyMappingRegistry.register((class_304)ReferencePointKey);
        selectAxisXKey = new class_304("key.axislock.select_x", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.axislock.keys");
        KeyMappingRegistry.register((class_304)selectAxisXKey);
        selectAxisYKey = new class_304("key.axislock.select_y", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.axislock.keys");
        KeyMappingRegistry.register((class_304)selectAxisYKey);
        selectAxisZKey = new class_304("key.axislock.select_z", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.axislock.keys");
        KeyMappingRegistry.register((class_304)selectAxisZKey);
    }

    public static void inputManager(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        InputManager.updateHoldAxisKey(client);
        InputManager.toggleMod(client);
        boolean bl = Axislock.config.general.mod_enabled = Axislock.config.general.mod_enabled || holdAxisKeyActive;
        if (!Axislock.config.general.mod_enabled) {
            BlockCheck.firstBlockInSequence = null;
        }
        InputManager.updateAxis(client);
        InputManager.handleReferencePointKey(client);
        InputManager.cycleMod(client);
    }

    private static void handleReferencePointKey(class_310 client) {
        class_3965 hitResult;
        if (!ReferencePointKey.method_1436()) {
            return;
        }
        if (InputManager.isDoublePress() && Axislock.config.general.manual_reference_point.toBlockPos() != null) {
            Axislock.config.general.manual_reference_point.reset(false);
            BlockCheck.firstBlockInSequence = null;
            InputManager.sendMessage(client, class_2561.method_43471((String)"axislock.reference_point.reset").getString(), class_124.field_1054);
            return;
        }
        class_3965 class_39652 = hitResult = client.field_1765 instanceof class_3965 ? (class_3965)client.field_1765 : null;
        if (client.field_1687 == null || client.field_1724 == null || hitResult == null) {
            return;
        }
        if (!client.field_1687.method_8320(hitResult.method_17777()).method_26215()) {
            Axislock.config.general.manual_reference_point.fromBlockPos(hitResult.method_17777());
            BlockCheck.firstBlockInSequence = null;
            InputManager.sendMessage(client, class_2561.method_43469((String)"axislock.reference_point.set", (Object[])new Object[]{hitResult.method_17777().method_23854()}).getString(), class_124.field_1054);
        } else {
            BlockCheck.firstBlockInSequence = null;
            Axislock.config.general.manual_reference_point.reset(false);
            InputManager.sendMessage(client, class_2561.method_43471((String)"axislock.reference_point.reset").getString(), class_124.field_1054);
        }
    }

    private static boolean isDoublePress() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        if (lastReferencePointPressTime == -1L) {
            lastReferencePointPressTime = client.field_1724.field_6012;
            return false;
        }
        boolean isDoublePress = (long)client.field_1724.field_6012 - lastReferencePointPressTime < 8L;
        lastReferencePointPressTime = isDoublePress ? -1L : (long)client.field_1724.field_6012;
        return isDoublePress;
    }

    private static void updateAxis(class_310 client) {
        Axis PreviousSelectedAxis = Axislock.config.general.current_axis;
        while (cycleAxisKey.method_1436()) {
            Axislock.config.general.current_axis = Axislock.config.general.current_axis.next();
        }
        if (selectAxisXKey.method_1436()) {
            Axislock.config.general.current_axis = Axis.X;
        } else if (selectAxisYKey.method_1436()) {
            Axislock.config.general.current_axis = Axis.Y;
        } else if (selectAxisZKey.method_1436()) {
            Axislock.config.general.current_axis = Axis.Z;
        }
        if (PreviousSelectedAxis != Axislock.config.general.current_axis) {
            BlockCheck.firstBlockInSequence = null;
            String message = class_2561.method_43469((String)"axislock.select", (Object[])new Object[]{Axislock.config.general.current_axis.toString()}).getString();
            InputManager.sendMessage(client, message, class_124.field_1068);
        }
    }

    private static void updateHoldAxisKey(class_310 client) {
        class_124 formatting;
        boolean previousHoldState = holdAxisKeyActive;
        holdAxisKeyActive = Axislock.config.extra.key_axislock_hold_is_normally_open ? holdAxisLockKey.method_1434() : !holdAxisLockKey.method_1434();
        String message = holdAxisKeyActive ? class_2561.method_43471((String)"axislock.hold.enabled").getString() : class_2561.method_43471((String)"axislock.hold.disabled").getString();
        class_124 class_1242 = formatting = holdAxisKeyActive ? class_124.field_1060 : class_124.field_1061;
        if (holdAxisKeyActive && !previousHoldState) {
            InputManager.sendMessage(client, message.formatted(new Object[]{Axislock.config.general.current_axis}), formatting);
        }
    }

    private static void toggleMod(class_310 client) {
        if (toggleModKey.method_1436()) {
            if (!holdAxisKeyActive) {
                Axislock.config.general.mod_enabled = !Axislock.config.general.mod_enabled;
                String message = Axislock.config.general.mod_enabled ? class_2561.method_43471((String)"axislock.toggle.enabled").getString() : class_2561.method_43471((String)"axislock.toggle.disabled").getString();
                class_124 formatting = Axislock.config.general.mod_enabled ? class_124.field_1060 : class_124.field_1061;
                InputManager.sendMessage(client, message.formatted(new Object[]{Axislock.config.general.current_axis}), formatting);
            } else {
                InputManager.sendMessage(client, class_2561.method_43471((String)"axislock.toggle.ignored").getString(), class_124.field_1054);
            }
        }
    }

    private static void cycleMod(class_310 client) {
        boolean modeChanged = false;
        while (cycleModeKey.method_1436()) {
            Axislock.config.general.current_mode = Axislock.config.general.current_mode.next();
            modeChanged = true;
        }
        if (!modeChanged) {
            return;
        }
        String modeMessage = switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> class_2561.method_43471((String)"axislock.mode.changed.placement").getString();
            case AxislockMode.BREAKING -> class_2561.method_43471((String)"axislock.mode.changed.breaking").getString();
            case AxislockMode.BOTH -> class_2561.method_43471((String)"axislock.mode.changed.placement_and_breaking").getString();
        };
        InputManager.sendMessage(client, modeMessage, class_124.field_1054);
    }

    private static void sendMessage(class_310 client, String message, class_124 formatting) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (formatting == null) {
            formatting = class_124.field_1068;
        }
        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message).method_27692(formatting), true);
    }

    static {
        holdAxisKeyActive = false;
        lastReferencePointPressTime = -1L;
    }
}

