/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.dataclasses.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class BlockPlacementCheck {
    public static boolean checkEnabled = false;
    public static Axis currentSelectedAxis = Axis.Y;
    public static BlockPos manualReferencePoint = null;
    public static BlockPos firstBlockInSequence = null;

    public static InteractionResult onBlockPlaceAttempt(Player player, Level world, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos referencePosForCheck;
        if (!world.isClientSide() || !checkEnabled || player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack stackInHand = player.getItemInHand(hand);
        if (!(stackInHand.getItem() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockPos potentialPlacePos = hitResult.getBlockPos().relative(hitResult.getDirection());
        if (!world.getBlockState(potentialPlacePos).isAir() || !world.isInWorldBounds(potentialPlacePos)) {
            return InteractionResult.PASS;
        }
        if (!world.getWorldBorder().isWithinBounds(potentialPlacePos)) {
            return InteractionResult.PASS;
        }
        if (manualReferencePoint != null) {
            referencePosForCheck = manualReferencePoint;
        } else {
            if (firstBlockInSequence == null) {
                firstBlockInSequence = potentialPlacePos;
                return InteractionResult.PASS;
            }
            referencePosForCheck = firstBlockInSequence;
        }
        boolean allowPlacement = switch (currentSelectedAxis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (potentialPlacePos.getX() == referencePosForCheck.getX()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (potentialPlacePos.getY() == referencePosForCheck.getY()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> potentialPlacePos.getZ() == referencePosForCheck.getZ();
        };
        return allowPlacement ? InteractionResult.PASS : InteractionResult.FAIL;
    }
}

