/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock.neoforge.client;

import com.c24rew.axislock.AxislockCommon;
import com.c24rew.axislock.BlockPlacementCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="axislock", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AxislockNeoForge {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AxislockCommon.init();
            AxislockCommon.LOGGER.info("AxisLock NeoForge Client Initialized");
            NeoForge.EVENT_BUS.register(AxislockClientEvents.class);
        });
    }

    @EventBusSubscriber(modid="axislock", value={Dist.CLIENT})
    public static class AxislockClientEvents {
        @SubscribeEvent
        public static void onInteract(InputEvent.InteractionKeyMappingTriggered event) {
            BlockHitResult hitResult;
            if (!event.isUseItem()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            ClientLevel level = mc.level;
            BlockHitResult blockHitResult = hitResult = mc.hitResult instanceof BlockHitResult ? (BlockHitResult)mc.hitResult : null;
            if (player == null || level == null || !(hitResult instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult2 = hitResult;
            InteractionResult commonResult = BlockPlacementCheck.onBlockPlaceAttempt((Player)player, (Level)level, event.getHand(), blockHitResult2);
            if (commonResult == InteractionResult.FAIL) {
                event.setCanceled(true);
            }
        }
    }
}

