/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class HUDRenderer {
    public static void init() {
        ClientGuiEvent.RENDER_HUD.register(HUDRenderer::renderHud);
    }

    private static void renderHud(class_332 context, class_9779 renderTickCounter) {
        class_2338 referencePoint;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || !client.field_1724.method_5805()) {
            return;
        }
        if (!Axislock.config.general.mod_enabled || !Axislock.config.hud.enabled) {
            return;
        }
        context.method_51448().pushMatrix();
        float scale = 0.7f * (float)Axislock.config.hud.size / 50.0f;
        class_327 font = client.field_1772;
        class_2338 manualReferencePoint = Axislock.config.general.manual_reference_point.toBlockPos();
        class_2338 class_23382 = referencePoint = manualReferencePoint != null ? manualReferencePoint : BlockCheck.firstBlockInSequence;
        if (referencePoint == null) {
            context.method_51448().popMatrix();
            return;
        }
        context.method_51448().scale(scale, scale);
        String cord = switch (Axislock.config.general.current_axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> "X= " + referencePoint.method_10263();
            case Axis.Y -> "Y= " + referencePoint.method_10264();
            case Axis.Z -> "Z= " + referencePoint.method_10260();
        };
        String lockText = switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> class_2561.method_43471((String)"axislock.place").getString();
            case AxislockMode.BREAKING -> class_2561.method_43471((String)"axislock.break").getString();
            case AxislockMode.BREAKING_AND_PLACEMENT -> class_2561.method_43471((String)"axislock.both").getString();
        };
        String fullText = lockText + " " + cord;
        int textWidth = font.method_1727(fullText);
        Objects.requireNonNull(font);
        int textHeight = 9;
        context.method_25294(Axislock.config.hud.position.x - 2, Axislock.config.hud.position.y - 2, Axislock.config.hud.position.x + textWidth + 2, Axislock.config.hud.position.y + textHeight + 2, Axislock.config.hud.background_color);
        int color = HUDRenderer.getCombinedColor(Axislock.config.hud.color, Axislock.config.hud.opacity);
        context.method_51433(font, fullText, Axislock.config.hud.position.x, Axislock.config.hud.position.y, color, Axislock.config.hud.shadow);
        context.method_51448().popMatrix();
    }

    public static int getCombinedColor(int color, int opacity) {
        int alpha = (int)((double)opacity / 100.0 * 255.0);
        return alpha << 24 | color & 0xFFFFFF;
    }
}

