/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class HUDRenderer {
    public static void init() {
        ClientGuiEvent.RENDER_HUD.register(HUDRenderer::renderHud);
    }

    private static void renderHud(GuiGraphics context, DeltaTracker renderTickCounter) {
        BlockPos referencePoint;
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.level == null || !client.player.isAlive()) {
            return;
        }
        if (!Axislock.config.general.mod_enabled || !Axislock.config.hud.enabled) {
            return;
        }
        context.pose().pushMatrix();
        float scale = 0.7f * (float)Axislock.config.hud.size / 50.0f;
        Font font = client.font;
        BlockPos manualReferencePoint = Axislock.config.general.manual_reference_point.toBlockPos();
        BlockPos blockPos = referencePoint = manualReferencePoint != null ? manualReferencePoint : BlockCheck.firstBlockInSequence;
        if (referencePoint == null) {
            context.pose().popMatrix();
            return;
        }
        context.pose().scale(scale, scale);
        String cord = switch (Axislock.config.general.current_axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> "X= " + referencePoint.getX();
            case Axis.Y -> "Y= " + referencePoint.getY();
            case Axis.Z -> "Z= " + referencePoint.getZ();
        };
        String lockText = switch (Axislock.config.general.current_mode) {
            default -> throw new MatchException(null, null);
            case AxislockMode.PLACEMENT -> Component.translatable((String)"axislock.place").getString();
            case AxislockMode.BREAKING -> Component.translatable((String)"axislock.break").getString();
            case AxislockMode.BREAKING_AND_PLACEMENT -> Component.translatable((String)"axislock.both").getString();
        };
        String fullText = lockText + " " + cord;
        int textWidth = font.width(fullText);
        Objects.requireNonNull(font);
        int textHeight = 9;
        context.fill(Axislock.config.hud.position.x - 2, Axislock.config.hud.position.y - 2, Axislock.config.hud.position.x + textWidth + 2, Axislock.config.hud.position.y + textHeight + 2, Axislock.config.hud.background_color);
        int color = HUDRenderer.getCombinedColor(Axislock.config.hud.color, Axislock.config.hud.opacity);
        context.drawString(font, fullText, Axislock.config.hud.position.x, Axislock.config.hud.position.y, color, Axislock.config.hud.shadow);
        context.pose().popMatrix();
    }

    public static int getCombinedColor(int color, int opacity) {
        int alpha = (int)((double)opacity / 100.0 * 255.0);
        return alpha << 24 | color & 0xFFFFFF;
    }
}

