/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock.config;

import com.c24rew.axislock.Axislock;
import com.c24rew.axislock.enums.Axis;
import com.c24rew.axislock.enums.AxislockMode;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.core.BlockPos;

@Config(name="axislock")
public class AxislockConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.TransitiveObject
    public GeneralConfig general = new GeneralConfig();
    @ConfigEntry.Category(value="hud")
    @ConfigEntry.Gui.TransitiveObject
    public HUDConfig hud = new HUDConfig();
    @ConfigEntry.Category(value="extra")
    @ConfigEntry.Gui.TransitiveObject
    public ExtraConfig extra = new ExtraConfig();

    public static void register() {
        AutoConfig.register(AxislockConfig.class, Toml4jConfigSerializer::new);
    }

    public static class GeneralConfig {
        public boolean mod_enabled = false;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public AxislockMode current_mode = AxislockMode.PLACEMENT;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Axis current_axis = Axis.Y;
        public boolean use_manual_reference_point = false;
        @ConfigEntry.Gui.CollapsibleObject
        public BlockPosition manual_reference_point = new BlockPosition();

        public static class BlockPosition {
            public int x = 0;
            public int y = 0;
            public int z = 0;

            public BlockPos toBlockPos() {
                if (!Axislock.config.general.use_manual_reference_point) {
                    return null;
                }
                return new BlockPos(this.x, this.y, this.z);
            }

            public void fromBlockPos(BlockPos pos) {
                Axislock.config.general.use_manual_reference_point = true;
                if (pos != null) {
                    this.x = pos.getX();
                    this.y = pos.getY();
                    this.z = pos.getZ();
                }
            }

            public void reset() {
                this.x = 0;
                this.y = 0;
                this.z = 0;
                Axislock.config.general.use_manual_reference_point = false;
            }
        }
    }

    public static class HUDConfig {
        public boolean enabled = true;
        @ConfigEntry.Gui.CollapsibleObject
        public Position position = new Position();
        @ConfigEntry.BoundedDiscrete(min=10L, max=100L)
        public int size = 50;
        @ConfigEntry.ColorPicker
        public int color = 0xFFFFFF;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int opacity = 80;
        @ConfigEntry.ColorPicker(allowAlpha=true)
        public int background_color = 0;
        public boolean shadow = true;

        public static class Position {
            public int x = 370;
            public int y = 8;
        }
    }

    public static class ExtraConfig {
        public boolean key_axislock_hold_is_normally_open = true;
    }
}

