/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.dataclasses.Axis;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.BlockHitResult;

public class KeyManager {
    private static KeyMapping toggleModKey;
    private static KeyMapping holdAxisLockKey;
    private static KeyMapping cycleAxisKey;
    private static KeyMapping cycleModeKey;
    private static KeyMapping ReferencePointKey;
    private static KeyMapping selectAxisXKey;
    private static KeyMapping selectAxisYKey;
    private static KeyMapping selectAxisZKey;
    private static boolean toggleState;
    private static boolean holdAxisKeyActive;

    public static void registerKeys() {
        toggleModKey = new KeyMapping("key.axislock.toggle", InputConstants.Type.KEYSYM, 82, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)toggleModKey);
        holdAxisLockKey = new KeyMapping("key.axislock.hold", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)holdAxisLockKey);
        cycleAxisKey = new KeyMapping("key.axislock.cycle_axis", InputConstants.Type.KEYSYM, 89, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)cycleAxisKey);
        cycleModeKey = new KeyMapping("key.axislock.cycle_mode", InputConstants.Type.KEYSYM, 78, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)cycleModeKey);
        ReferencePointKey = new KeyMapping("key.axislock.set_reference_point", InputConstants.Type.KEYSYM, 66, "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)ReferencePointKey);
        selectAxisXKey = new KeyMapping("key.axislock.select_x", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisXKey);
        selectAxisYKey = new KeyMapping("key.axislock.select_y", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisYKey);
        selectAxisZKey = new KeyMapping("key.axislock.select_z", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "category.axislock.keys");
        KeyMappingRegistry.register((KeyMapping)selectAxisZKey);
    }

    public static void inputManager(Minecraft client) {
        if (client.player == null || client.level == null) {
            return;
        }
        KeyManager.updateHoldAxisKey(client);
        KeyManager.toggleMod(client);
        if (!holdAxisKeyActive && !toggleState) {
            BlockCheck.firstBlockInSequence = null;
        }
        BlockCheck.checkEnabled = toggleState || holdAxisKeyActive;
        KeyManager.updateAxis(client);
        KeyManager.handleReferencePointKey(client);
        KeyManager.cycleMod(client);
    }

    private static void handleReferencePointKey(Minecraft client) {
        if (ReferencePointKey.consumeClick()) {
            BlockHitResult hitResult;
            if (BlockCheck.manualReferencePoint != null) {
                KeyManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.reset").getString(), ChatFormatting.YELLOW);
                BlockCheck.firstBlockInSequence = null;
                BlockCheck.manualReferencePoint = null;
                return;
            }
            BlockHitResult blockHitResult = hitResult = client.hitResult instanceof BlockHitResult ? (BlockHitResult)client.hitResult : null;
            if (client.level != null && hitResult != null && !client.level.getBlockState(hitResult.getBlockPos()).isAir()) {
                BlockCheck.manualReferencePoint = hitResult.getBlockPos();
                BlockCheck.firstBlockInSequence = null;
                KeyManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.set", (Object[])new Object[]{BlockCheck.manualReferencePoint.toShortString()}).getString(), ChatFormatting.YELLOW);
            } else {
                KeyManager.sendMessage(client, Component.translatable((String)"axislock.reference_point.error").getString(), ChatFormatting.RED);
            }
        }
    }

    private static void updateAxis(Minecraft client) {
        Axis PreviousSelectedAxis = BlockCheck.currentSelectedAxis;
        while (cycleAxisKey.consumeClick()) {
            BlockCheck.currentSelectedAxis = BlockCheck.currentSelectedAxis.next();
        }
        if (selectAxisXKey.consumeClick()) {
            BlockCheck.currentSelectedAxis = Axis.X;
        } else if (selectAxisYKey.consumeClick()) {
            BlockCheck.currentSelectedAxis = Axis.Y;
        } else if (selectAxisZKey.consumeClick()) {
            BlockCheck.currentSelectedAxis = Axis.Z;
        }
        if (PreviousSelectedAxis != BlockCheck.currentSelectedAxis) {
            BlockCheck.firstBlockInSequence = null;
            String message = Component.translatable((String)"axislock.select", (Object[])new Object[]{BlockCheck.currentSelectedAxis.toString()}).getString();
            KeyManager.sendMessage(client, message, ChatFormatting.WHITE);
        }
    }

    private static void updateHoldAxisKey(Minecraft client) {
        ChatFormatting formatting;
        boolean previousHoldState = holdAxisKeyActive;
        holdAxisKeyActive = holdAxisLockKey.isDown();
        String message = holdAxisKeyActive ? Component.translatable((String)"axislock.hold.enabled").getString() : Component.translatable((String)"axislock.hold.disabled").getString();
        ChatFormatting chatFormatting = formatting = holdAxisKeyActive ? ChatFormatting.GREEN : ChatFormatting.RED;
        if (holdAxisKeyActive && !previousHoldState) {
            KeyManager.sendMessage(client, message.formatted(new Object[]{BlockCheck.currentSelectedAxis}), formatting);
        }
    }

    private static void toggleMod(Minecraft client) {
        if (toggleModKey.consumeClick() && !holdAxisKeyActive) {
            toggleState = !toggleState;
            String message = toggleState ? Component.translatable((String)"axislock.toggle.enabled").getString() : Component.translatable((String)"axislock.toggle.disabled").getString();
            ChatFormatting formatting = toggleState ? ChatFormatting.GREEN : ChatFormatting.RED;
            KeyManager.sendMessage(client, message.formatted(new Object[]{BlockCheck.currentSelectedAxis}), formatting);
        }
    }

    private static void cycleMod(Minecraft client) {
        boolean modeChanged = false;
        while (cycleModeKey.consumeClick()) {
            BlockCheck.currentMode = BlockCheck.currentMode.next();
            modeChanged = true;
        }
        if (!modeChanged) {
            return;
        }
        String modeMessage = switch (BlockCheck.currentMode) {
            default -> throw new MatchException(null, null);
            case BlockCheck.AxislockMode.PLACEMENT -> Component.translatable((String)"axislock.mode.placement").getString();
            case BlockCheck.AxislockMode.BREAKING -> Component.translatable((String)"axislock.mode.breaking").getString();
            case BlockCheck.AxislockMode.BREAKING_AND_PLACEMENT -> Component.translatable((String)"axislock.mode.placement_and_breaking").getString();
        };
        KeyManager.sendMessage(client, modeMessage, ChatFormatting.YELLOW);
    }

    private static void sendMessage(Minecraft client, String message, ChatFormatting formatting) {
        if (client.player == null || client.level == null) {
            return;
        }
        if (formatting == null) {
            formatting = ChatFormatting.WHITE;
        }
        client.player.displayClientMessage((Component)Component.literal((String)message).withStyle(formatting), true);
    }

    static {
        toggleState = false;
        holdAxisKeyActive = false;
    }
}

