/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock.dataclasses;

import com.c24rew.axislock.ConfigManager;

public abstract class ConfigEntry<T> {
    private final String id;
    private final String translationKey;
    private final String descriptionTranslationKey;
    private final T defaultValue;

    public ConfigEntry(String id, String translationKey, String descriptionTranslationKey, T defaultValue) {
        this.id = id;
        this.translationKey = translationKey;
        this.descriptionTranslationKey = descriptionTranslationKey;
        this.defaultValue = defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getDescriptionTranslationKey() {
        return this.descriptionTranslationKey;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return ConfigManager.getInstance().getValue(this.id, this.getValueClass());
    }

    public void setValue(T value) {
        ConfigManager.getInstance().setValue(this.id, value);
    }

    protected abstract Class<T> getValueClass();
}

