/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.axislock;

import com.c24rew.axislock.BlockCheck;
import com.c24rew.axislock.dataclasses.Axis;
import dev.architectury.event.events.client.ClientGuiEvent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class HUDRenderer {
    public static void init() {
        ClientGuiEvent.RENDER_HUD.register(HUDRenderer::renderHud);
    }

    private static void renderHud(GuiGraphics context, DeltaTracker renderTickCounter) {
        BlockPos referencePoint;
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.level == null || !client.player.isAlive()) {
            return;
        }
        if (!BlockCheck.checkEnabled) {
            return;
        }
        context.pose().pushMatrix();
        float scale = 0.7f;
        Font font = client.font;
        BlockPos blockPos = referencePoint = BlockCheck.manualReferencePoint != null ? BlockCheck.manualReferencePoint : BlockCheck.firstBlockInSequence;
        if (referencePoint == null) {
            context.pose().popMatrix();
            return;
        }
        context.pose().scale(scale, scale);
        String cord = switch (BlockCheck.currentSelectedAxis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> "X= " + referencePoint.getX();
            case Axis.Y -> "Y= " + referencePoint.getY();
            case Axis.Z -> "Z= " + referencePoint.getZ();
        };
        String lockText = switch (BlockCheck.currentMode) {
            default -> throw new MatchException(null, null);
            case BlockCheck.AxislockMode.PLACEMENT -> Component.translatable((String)"axislock.place").getString();
            case BlockCheck.AxislockMode.BREAKING -> Component.translatable((String)"axislock.break").getString();
            case BlockCheck.AxislockMode.BREAKING_AND_PLACEMENT -> Component.translatable((String)"axislock.both").getString();
        };
        context.drawString(font, lockText + " " + cord, 370, 8, -1090519041, true);
        context.pose().popMatrix();
    }
}

