/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.fakeseed;

import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class FakeSeed
extends JavaPlugin
implements Listener,
CommandExecutor {
    private Random random = new Random();
    private boolean useRandomSeed;
    private List<String> customSeeds;
    private String seedMessage;
    private boolean interceptCommand;
    private String noSeedMessage;
    private boolean useNoSeedMessage;
    private int percentChanceNoSeed;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("fakeseedreload").setExecutor(this);
        this.getLogger().info("FakeSeed has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("FakeSeed has been disabled!");
    }

    private void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.useRandomSeed = config.getBoolean("use-random-seed", true);
        this.customSeeds = config.getStringList("custom-seeds");
        this.seedMessage = ChatColor.translateAlternateColorCodes('&', config.getString("seed-message", "&eSeed: &f%seed%"));
        this.interceptCommand = config.getBoolean("intercept-command", true);
        this.noSeedMessage = ChatColor.translateAlternateColorCodes('&', config.getString("no-seed-message", "&cNo seed available for this world"));
        this.useNoSeedMessage = config.getBoolean("use-no-seed-message", false);
        this.percentChanceNoSeed = config.getInt("percent-chance-no-seed", 10);
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.interceptCommand) {
            return;
        }
        String command = event.getMessage().toLowerCase();
        if (command.equals("/seed") || command.startsWith("/seed ")) {
            event.setCancelled(true);
            this.handleSeedCommand(event.getPlayer());
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("fakeseedreload")) {
            if (!sender.hasPermission("fakeseed.reload")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.loadConfig();
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "FakeSeed configuration reloaded!");
            return true;
        }
        return false;
    }

    private void handleSeedCommand(CommandSender sender) {
        if (this.useNoSeedMessage && this.random.nextInt(100) < this.percentChanceNoSeed) {
            sender.sendMessage(this.noSeedMessage);
            return;
        }
        String seed = this.useRandomSeed ? String.valueOf(this.random.nextLong()) : (this.customSeeds.isEmpty() ? String.valueOf(this.random.nextLong()) : this.customSeeds.get(this.random.nextInt(this.customSeeds.size())));
        String message = this.seedMessage.replace("%seed%", seed);
        sender.sendMessage(message);
    }
}

