/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vzling.lib.client.renderer.VzlingRenderType;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractTrailParticle
extends class_703 {
    private final class_243[] trailPositions = new class_243[64];
    public int r;
    public int g;
    public int b;
    protected float trailA = 1.0f;
    private int trailPointer = -1;

    public AbstractTrailParticle(class_638 world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z);
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void method_3070() {
        this.tickTrail();
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_3852 *= 0.99;
        this.field_3869 *= 0.99;
        this.field_3850 *= 0.99;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            this.field_3869 -= (double)this.field_3844;
        }
    }

    public void tickTrail() {
        class_243 currentPosition = new class_243(this.field_3874, this.field_3854, this.field_3871);
        if (this.trailPointer == -1) {
            Arrays.fill(this.trailPositions, currentPosition);
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = currentPosition;
    }

    public void method_3074(class_4588 consumer, class_4184 camera, float partialTick) {
        if (this.trailPointer > -1) {
            class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexconsumer = this.getVetrexConsumer(multibuffersource$buffersource);
            class_243 cameraPos = camera.method_19326();
            double x = (float)class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874);
            double y = (float)class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854);
            double z = (float)class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871);
            class_4587 posestack = new class_4587();
            posestack.method_22903();
            posestack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
            class_243 drawFrom = new class_243(x, y, z);
            float zRot = this.getTrailRot(camera);
            class_243 topAngleVec = new class_243(0.0, (double)(this.getTrailHeight() / 2.0f), 0.0).method_31033(zRot);
            class_243 bottomAngleVec = new class_243(0.0, (double)(this.getTrailHeight() / -2.0f), 0.0).method_31033(zRot);
            int j = this.method_3068(partialTick);
            for (int samples = 0; samples < this.sampleCount(); ++samples) {
                class_243 sample = this.getTrailPosition(samples * this.sampleStep(), partialTick);
                float u1 = (float)samples / (float)this.sampleCount();
                float u2 = u1 + 1.0f / (float)this.sampleCount();
                class_243 draw1 = drawFrom;
                class_4587.class_4665 posestack$pose = posestack.method_23760();
                Matrix4f matrix4f = posestack$pose.method_23761();
                Matrix3f matrix3f = posestack$pose.method_23762();
                vertexconsumer.method_22918(matrix4f, (float)draw1.field_1352 + (float)bottomAngleVec.field_1352, (float)draw1.field_1351 + (float)bottomAngleVec.field_1351, (float)draw1.field_1350 + (float)bottomAngleVec.field_1350).method_22915((float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, this.trailA).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_22916(j).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
                vertexconsumer.method_22918(matrix4f, (float)sample.field_1352 + (float)bottomAngleVec.field_1352, (float)sample.field_1351 + (float)bottomAngleVec.field_1351, (float)sample.field_1350 + (float)bottomAngleVec.field_1350).method_22915((float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, this.trailA).method_22913(u2, 1.0f).method_22922(class_4608.field_21444).method_22916(j).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
                vertexconsumer.method_22918(matrix4f, (float)sample.field_1352 + (float)topAngleVec.field_1352, (float)sample.field_1351 + (float)topAngleVec.field_1351, (float)sample.field_1350 + (float)topAngleVec.field_1350).method_22915((float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, this.trailA).method_22913(u2, 0.0f).method_22922(class_4608.field_21444).method_22916(j).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
                vertexconsumer.method_22918(matrix4f, (float)draw1.field_1352 + (float)topAngleVec.field_1352, (float)draw1.field_1351 + (float)topAngleVec.field_1351, (float)draw1.field_1350 + (float)topAngleVec.field_1350).method_22915((float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, this.trailA).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_22916(j).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
                drawFrom = sample;
            }
            multibuffersource$buffersource.method_22993();
            posestack.method_22909();
        }
    }

    protected class_4588 getVetrexConsumer(class_4597.class_4598 multibuffersource$buffersource) {
        return multibuffersource$buffersource.getBuffer(VzlingRenderType.getTrailEffect(this.getTrailTexture()));
    }

    public float getTrailRot(class_4184 camera) {
        return (float)(-Math.PI) / 180 * camera.method_19329();
    }

    public abstract float getTrailHeight();

    public abstract class_2960 getTrailTexture();

    public int sampleCount() {
        return 20;
    }

    public int sampleStep() {
        return 1;
    }

    public class_243 getTrailPosition(int pointer, float partialTick) {
        if (this.field_3843) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        class_243 d0 = this.trailPositions[j];
        class_243 d1 = this.trailPositions[i].method_1020(d0);
        return d0.method_1019(d1.method_1021((double)partialTick));
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17831;
    }
}

