/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.renderer.LaserBeamRenderer;
import vzling.lib.entity.ExampleLaserBeamEntity;

@Environment(value=EnvType.CLIENT)
public class ExampleLaserBeamEntityRenderer<T extends ExampleLaserBeamEntity>
extends LaserBeamRenderer<T> {
    public ExampleLaserBeamEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public float getBeamRadius(T entity) {
        return 0.6f;
    }

    @Override
    public void renderBeamPart(T entity, float length, float tickCount, float partialTicks, class_4587 stack, class_4588 consumer, int light) {
        class_4587.class_4665 pose = stack.method_23760();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.025f % this.getTextureWidth();
        float progress = 1.0f;
        if (((ExampleLaserBeamEntity)((Object)entity)).field_6012 <= 10) {
            progress = tickCount / 10.0f;
        }
        if (((ExampleLaserBeamEntity)((Object)entity)).deathTime > 0) {
            progress = 1.0f - ((float)((ExampleLaserBeamEntity)((Object)entity)).deathTime + partialTicks) / 10.0f;
        }
        this.vertex(pose, consumer, (-this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f) * progress, 0.0f, 0.0f, -xOffset, 0.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (-this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f) * progress, length, 0.0f, 1.0f - xOffset, 0.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f) * progress, length, 0.0f, 1.0f - xOffset, 1.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f) * progress, 0.0f, 0.0f, -xOffset, 1.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull T entity) {
        return new class_2960("vzling", "textures/entity/example_laser_beam.png");
    }
}

