/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import vzling.lib.entity.RayAttackUser;
import vzling.lib.util.EntityUtil;
import vzling.lib.util.MathUtil;

public class RayAttack
extends class_1297 {
    protected static final class_2940<Integer> CASTER = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> PITCH = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> YAW = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> LENGTH = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    public float prevPitch;
    public float prevYaw;

    public Optional<class_1297> getCaster() {
        return Optional.ofNullable(this.method_37908().method_8469(((Integer)this.method_5841().method_12789(CASTER)).intValue()));
    }

    public void setCaster(class_1297 caster) {
        this.method_5841().method_12778(CASTER, (Object)caster.method_5628());
    }

    public float getPitch() {
        return ((Float)this.method_5841().method_12789(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.method_5841().method_12778(PITCH, (Object)Float.valueOf(pitch));
    }

    public float getYaw() {
        return ((Float)this.method_5841().method_12789(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.method_5841().method_12778(YAW, (Object)Float.valueOf(yaw));
    }

    public float getLength() {
        return ((Float)this.method_5841().method_12789(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.method_5841().method_12778(LENGTH, (Object)Float.valueOf(length));
    }

    public RayAttack(class_1299<? extends RayAttack> type, class_1937 level) {
        super(type, level);
        this.field_5985 = true;
    }

    public RayAttack(class_1299<? extends RayAttack> type, class_1937 level, class_1309 caster, double x, double y, double z, float yaw, float pitch) {
        this(type, level);
        this.setCaster((class_1297)caster);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setLength(this.getRadius());
        this.method_5814(x, y, z);
    }

    protected void method_5693() {
        this.field_6011.method_12784(CASTER, (Object)-1);
        this.field_6011.method_12784(PITCH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(YAW, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LENGTH, (Object)Float.valueOf(0.0f));
    }

    @NotNull
    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            boolean hasBlock;
            class_243 idealEndPos;
            this.update();
            class_243 endPos = idealEndPos = MathUtil.rotationToPosition(this.method_19538(), this.getRadius(), this.getPitch(), this.getYaw());
            RaytraceResult result = RayAttack.raytrace((class_1936)this.method_37908(), this, this.method_19538(), idealEndPos);
            boolean bl = hasBlock = result.blockHitResult() != null && result.blockHitResult().method_17783() != class_239.class_240.field_1333;
            if (hasBlock) {
                endPos = result.blockHitResult().method_17784();
            }
            this.setLength((float)endPos.method_1022(this.method_19538()));
            result = RayAttack.raytrace((class_1936)this.method_37908(), this, this.method_19538(), endPos);
            this.onHit(result);
        } else {
            this.prevYaw = this.getYaw();
            this.prevPitch = this.getPitch();
            this.field_6014 = this.method_23317();
            this.field_6036 = this.method_23318();
            this.field_5969 = this.method_23321();
            class_243 endPos = MathUtil.rotationToPosition(this.method_19538(), this.getLength(), this.getPitch(), this.getYaw());
            this.addEndParticles(endPos);
        }
    }

    public int getRadius() {
        return 20;
    }

    public void onHit(RaytraceResult result) {
        for (class_1297 target : result.entities()) {
            if (!(target instanceof class_1309)) continue;
            class_1309 living = (class_1309)target;
            if (!this.getCaster().isEmpty() && living.method_5667().equals(this.getCaster().get().method_5667())) continue;
            this.doHurtTarget(living);
        }
    }

    public void doHurtTarget(class_1309 target) {
        this.getCaster().ifPresent(caster -> EntityUtil.forceHurt(target, this.method_48923().method_48813(), this.getAttackDamage()));
    }

    public void addEndParticles(class_243 endPos) {
        for (int i = 0; i < 4; ++i) {
            this.method_37908().method_8466((class_2394)class_2398.field_11236, true, endPos.field_1352 + (double)this.field_5974.method_43057() - 0.5, endPos.field_1351 + (double)this.field_5974.method_43057() - 0.5, endPos.field_1350 + (double)this.field_5974.method_43057() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public float getRotationSpeed() {
        return 1.6f;
    }

    public float getAttackDamage() {
        return 3.0f;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5640(double distance) {
        return distance < 1024.0;
    }

    protected void method_5749(class_2487 compoundTag) {
    }

    protected void method_5652(class_2487 compoundTag) {
    }

    private void update() {
        this.updateRotations();
        this.updatePosition();
    }

    protected float rotateTowards(float from, float to, float maxAngle) {
        float f = class_3532.method_15381((float)from, (float)to);
        float f1 = class_3532.method_15363((float)f, (float)(-maxAngle), (float)maxAngle);
        return from + f1;
    }

    public void updateRotations() {
        this.getCaster().ifPresent(caster -> {
            if (caster instanceof class_1309) {
                RayAttackUser shooter;
                class_1309 living = (class_1309)caster;
                if (caster instanceof RayAttackUser && !(shooter = (RayAttackUser)caster).isRayFollowingHeadRotation()) {
                    class_243 idealEndPos = MathUtil.rotationToPosition(this.method_19538(), this.getRadius(), this.getPitch(), this.getYaw());
                    shooter.updateRayEnd(idealEndPos);
                    class_243 wantedPos = shooter.getRayRotationTarget();
                    float wantedYaw = MathUtil.positionToYaw(this.method_19538(), wantedPos);
                    float wantedPitch = MathUtil.positionToPitch(this.method_19538(), wantedPos);
                    float currentYaw = this.getYaw();
                    float currentPitch = this.getPitch();
                    this.setYaw(this.rotateTowards(currentYaw, wantedYaw, this.getRotationSpeed()));
                    this.setPitch(this.rotateTowards(currentPitch, wantedPitch, this.getRotationSpeed()));
                } else {
                    this.setYaw(living.field_6241 + 90.0f);
                    this.setPitch(-caster.method_36455());
                }
            }
        });
    }

    public void updatePosition() {
        this.getCaster().ifPresent(caster -> this.method_33574(this.getPositionForCaster((class_1297)caster, caster.method_19538())));
    }

    public class_243 getPositionForCaster(class_1297 caster, class_243 casterPos) {
        return casterPos;
    }

    public static RaytraceResult raytrace(class_1936 level, class_1297 entity, class_243 from, class_243 to) {
        class_3965 hitResult = level.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        RaytraceResult result = new RaytraceResult(new ArrayList<class_1297>(), (class_3965)(hitResult.method_17783() == class_239.class_240.field_1332 ? hitResult : null));
        List entities = level.method_18467(class_1297.class, new class_238(Math.min(from.field_1352, to.field_1352), Math.min(from.field_1351, to.field_1351), Math.min(from.field_1350, to.field_1350), Math.max(from.field_1352, to.field_1352), Math.max(from.field_1351, to.field_1351), Math.max(from.field_1350, to.field_1350)).method_1014(1.0));
        for (class_1297 entity1 : entities) {
            class_238 aabb = entity1.method_5829().method_1014((double)(entity1.method_5871() + 0.5f));
            if (aabb.method_1006(from)) {
                result.entities().add(entity1);
                continue;
            }
            if (!aabb.method_992(from, to).isPresent()) continue;
            result.entities().add(entity1);
        }
        result.entities().sort((o1, o2) -> (int)Math.signum(o1.method_19538().method_1022(from) - o2.method_19538().method_1022(from)));
        return result;
    }

    public record RaytraceResult(List<class_1297> entities, class_3965 blockHitResult) {
    }
}

