/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.animation;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import vzling.lib.animation.VzlingAnimation;

public interface VzlingAnimatable {
    default public void playAnimation(Entity entity, VzlingAnimation animation) {
        if (entity.m_9236_().f_46443_ && this.shouldPlayAnimation(entity, animation)) {
            animation.getState().m_216977_(entity.f_19797_);
        }
    }

    default public void playAnimationIfStopped(Entity entity, VzlingAnimation animation) {
        if (entity.m_9236_().f_46443_ && this.shouldPlayAnimation(entity, animation)) {
            animation.getState().m_216982_(entity.f_19797_);
        }
    }

    default public void stopAnimation(Entity entity, VzlingAnimation animation) {
        if (entity.m_9236_().f_46443_) {
            animation.getState().m_216973_();
        }
    }

    default public void playAnimation(Entity entity, ResourceLocation location) {
        VzlingAnimation animation = this.getAnimation(location);
        this.playAnimation(entity, animation);
    }

    default public void playAnimationIfStopped(Entity entity, ResourceLocation location) {
        VzlingAnimation animation = this.getAnimation(location);
        this.playAnimationIfStopped(entity, animation);
    }

    default public void stopAnimation(Entity entity, ResourceLocation location) {
        VzlingAnimation animation = this.getAnimation(location);
        this.stopAnimation(entity, animation);
    }

    default public boolean shouldPlayAnimation(Entity entity, VzlingAnimation animation) {
        return entity.m_6084_();
    }

    @Nullable
    default public VzlingAnimation getAnimation(ResourceLocation animationId) {
        for (VzlingAnimation animation : this.getAnimations()) {
            if (!animation.getId().equals((Object)animationId)) continue;
            return animation;
        }
        return null;
    }

    public List<VzlingAnimation> getAnimations();
}

