/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.json;

import com.google.gson.annotations.SerializedName;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GeoModelBuilder {
    public static ItemTransforms buildItemTransforms(GeometryModel model) {
        if (model.itemDisplayTransforms == null) {
            return ItemTransforms.f_111786_;
        }
        GeometryModel.ItemDisplayTransforms transforms = model.itemDisplayTransforms;
        ItemTransform thirdRight = GeoModelBuilder.convert(transforms.thirdpersonRighthand);
        ItemTransform thirdLeft = GeoModelBuilder.convert(transforms.thirdpersonLefthand);
        ItemTransform firstRight = GeoModelBuilder.convert(transforms.firstpersonRighthand);
        ItemTransform firstLeft = GeoModelBuilder.convert(transforms.firstpersonLefthand);
        ItemTransform gui = GeoModelBuilder.convert(transforms.gui);
        ItemTransform ground = GeoModelBuilder.convert(transforms.ground);
        ItemTransform fixed = GeoModelBuilder.convert(transforms.fixed);
        return new ItemTransforms(thirdLeft, thirdRight, firstLeft, firstRight, ItemTransform.f_111754_, gui, ground, fixed);
    }

    private static ItemTransform convert(GeometryModel.ItemDisplayContext context) {
        if (context == null) {
            return ItemTransform.f_111754_;
        }
        Vector3f rotation = new Vector3f((float)Math.toRadians(context.rotation[0]), (float)Math.toRadians(context.rotation[1]), (float)Math.toRadians(context.rotation[2]));
        Vector3f translation = new Vector3f(context.translation[0] * 0.0625f, context.translation[1] * 0.0625f, context.translation[2] * 0.0625f);
        Vector3f scale = new Vector3f(context.scale[0], context.scale[1], context.scale[2]);
        return new ItemTransform(rotation, translation, scale);
    }

    public static class GeometryModel {
        @SerializedName(value="item_display_transforms")
        public ItemDisplayTransforms itemDisplayTransforms;

        public static class ItemDisplayContext {
            public float[] rotation;
            public float[] translation;
            public float[] scale;
        }

        public static class ItemDisplayTransforms {
            @SerializedName(value="thirdperson_righthand")
            public ItemDisplayContext thirdpersonRighthand;
            @SerializedName(value="thirdperson_lefthand")
            public ItemDisplayContext thirdpersonLefthand;
            @SerializedName(value="firstperson_righthand")
            public ItemDisplayContext firstpersonRighthand;
            @SerializedName(value="firstperson_lefthand")
            public ItemDisplayContext firstpersonLefthand;
            public ItemDisplayContext ground;
            public ItemDisplayContext gui;
            public ItemDisplayContext fixed;
        }
    }
}

