/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

@OnlyIn(value=Dist.CLIENT)
public class EyeTrailParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("vzling", "textures/particle/entity_trail.png");
    private final int entityId;
    private final double offset;

    public EyeTrailParticle(ClientLevel world, double x, double y, double z, int r, int g, int b, int entityId, double offset) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107226_ = 0.0f;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.entityId = entityId;
        this.offset = offset;
    }

    @Override
    public void m_5989_() {
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 0.8f * fade;
        Entity entity = this.f_107208_.m_6815_(this.entityId);
        if (entity != null) {
            Vec3 eyePos = entity.m_146892_();
            float yaw = entity.m_146908_() * ((float)Math.PI / 180);
            Vec3 forward = new Vec3((double)(-Mth.m_14031_((float)yaw)), 0.0, (double)Mth.m_14089_((float)yaw));
            Vec3 basePos = eyePos.m_82549_(forward.m_82490_(0.25));
            Vec3 pos = new Vec3(forward.f_82481_, 0.0, -forward.f_82479_);
            Vec3 target = basePos.m_82549_(pos.m_82490_(this.offset));
            Vec3 vec = target.m_82546_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_));
            this.f_107215_ = vec.m_7096_();
            this.f_107216_ = vec.m_7098_();
            this.f_107217_ = vec.m_7094_();
        } else {
            this.m_107274_();
        }
        super.m_5989_();
    }

    @Override
    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && this.entityId == player.m_19879_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            return;
        }
        super.m_5744_(consumer, camera, partialTick);
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 0.25f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public record ColorData(int r, int g, int b, int entityId, double offset) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<ColorData> DESERIALIZER = new ParticleOptions.Deserializer<ColorData>(){

            @NotNull
            public ColorData fromCommand(@NotNull ParticleType<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                int entityId = reader.readInt();
                reader.expect(' ');
                double offset = reader.readDouble();
                return new ColorData(r, g, b, entityId, offset);
            }

            @NotNull
            public ColorData fromNetwork(@NotNull ParticleType<ColorData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readDouble());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b), (App)Codec.INT.fieldOf("entityId").forGetter(ColorData::entityId), (App)Codec.DOUBLE.fieldOf("offset").forGetter(ColorData::offset)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeInt(this.entityId);
            buffer.writeDouble(this.offset);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, this.entityId, this.offset);
        }

        @NotNull
        public ParticleType<ColorData> m_6012_() {
            return ParticleInit.EYE_TRAIL.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColorData> {
        public Particle createParticle(ColorData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EyeTrailParticle(level, x, y, z, data.r(), data.g(), data.b(), data.entityId(), data.offset());
        }
    }
}

