/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

@OnlyIn(value=Dist.CLIENT)
public class TrailParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("vzling", "textures/particle/trail.png");
    private final double xPos;
    private final double yPos;
    private final double zPos;

    public TrailParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.f_107225_ = 40;
        this.f_107226_ = 0.0f;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.xPos = xd;
        this.yPos = yd;
        this.zPos = zd;
    }

    @Override
    public void m_5989_() {
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 0.8f * fade;
        Vec3 vec3 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 vec32 = new Vec3(this.xPos, this.yPos, this.zPos);
        if (vec3.m_82554_(vec32) <= 0.5) {
            this.f_107215_ = 0.0;
            this.f_107216_ = 0.0;
            this.f_107217_ = 0.0;
        } else {
            this.f_107215_ = new Vec3(this.xPos, this.yPos, this.zPos).m_82492_(this.f_107212_, this.f_107213_, this.f_107214_).m_82541_().m_7096_();
            this.f_107216_ = new Vec3(this.xPos, this.yPos, this.zPos).m_82492_(this.f_107212_, this.f_107213_, this.f_107214_).m_82541_().m_7098_();
            this.f_107217_ = new Vec3(this.xPos, this.yPos, this.zPos).m_82492_(this.f_107212_, this.f_107213_, this.f_107214_).m_82541_().m_7094_();
        }
        super.m_5989_();
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 0.5f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public record ColorData(int r, int g, int b) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<ColorData> DESERIALIZER = new ParticleOptions.Deserializer<ColorData>(){

            public @NotNull ColorData fromCommand(ParticleType<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new ColorData(r, g, b);
            }

            public @NotNull ColorData fromNetwork(ParticleType<ColorData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b);
        }

        @NotNull
        public ParticleType<ColorData> m_6012_() {
            return ParticleInit.TRAIL.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColorData> {
        public Particle createParticle(ColorData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.r(), data.g(), data.b());
        }
    }
}

