/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vzling.lib.client.renderer.VzlingRenderType;
import vzling.lib.entity.BulletEntity;

@OnlyIn(value=Dist.CLIENT)
public class BulletEntityRenderer<T extends BulletEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("vzling", "textures/particle/bullet_trail.png");

    public BulletEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return null;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        if (((BulletEntity)((Object)entity)).hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)((BulletEntity)((Object)entity)).f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)((BulletEntity)((Object)entity)).f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)((BulletEntity)((Object)entity)).f_19792_, (double)entity.m_20189_());
            stack.m_85836_();
            stack.m_85837_(-x, -y, -z);
            this.renderTrail(entity, partialTicks, stack, bufferSource, light);
            stack.m_85849_();
        }
    }

    private void renderTrail(T entity, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        int sampleSize = 3;
        Vec3 topAngleVec = new Vec3(0.0, 0.25, 0.0);
        Vec3 bottomAngleVec = new Vec3(0.0, -0.25, 0.0);
        Vec3 drawFrom = ((BulletEntity)((Object)entity)).getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(VzlingRenderType.getGlowingEffect(TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = ((BulletEntity)((Object)entity)).getTrailPosition(samples + 1, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = stack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_((float)((BulletEntity)((Object)entity)).trailR / 255.0f, (float)((BulletEntity)((Object)entity)).trailG / 255.0f, (float)((BulletEntity)((Object)entity)).trailB / 255.0f, 0.8f).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_((float)((BulletEntity)((Object)entity)).trailR / 255.0f, (float)((BulletEntity)((Object)entity)).trailG / 255.0f, (float)((BulletEntity)((Object)entity)).trailB / 255.0f, 0.8f).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_((float)((BulletEntity)((Object)entity)).trailR / 255.0f, (float)((BulletEntity)((Object)entity)).trailG / 255.0f, (float)((BulletEntity)((Object)entity)).trailB / 255.0f, 0.8f).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_((float)((BulletEntity)((Object)entity)).trailR / 255.0f, (float)((BulletEntity)((Object)entity)).trailG / 255.0f, (float)((BulletEntity)((Object)entity)).trailB / 255.0f, 0.8f).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }
}

