/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vzling.lib.entity.RayAttackUser;
import vzling.lib.util.EntityUtil;
import vzling.lib.util.MathUtil;

public class RayAttack
extends Entity {
    protected static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.m_135353_(RayAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float prevPitch;
    public float prevYaw;

    public Optional<Entity> getCaster() {
        return Optional.ofNullable(this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(CASTER)).intValue()));
    }

    public void setCaster(Entity caster) {
        this.m_20088_().m_135381_(CASTER, (Object)caster.m_19879_());
    }

    public float getPitch() {
        return ((Float)this.m_20088_().m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.m_20088_().m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    public float getYaw() {
        return ((Float)this.m_20088_().m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.m_20088_().m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getLength() {
        return ((Float)this.m_20088_().m_135370_(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.m_20088_().m_135381_(LENGTH, (Object)Float.valueOf(length));
    }

    public RayAttack(EntityType<? extends RayAttack> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public RayAttack(EntityType<? extends RayAttack> type, Level level, LivingEntity caster, double x, double y, double z, float yaw, float pitch) {
        this(type, level);
        this.setCaster((Entity)caster);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setLength(this.getRadius());
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CASTER, (Object)-1);
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LENGTH, (Object)Float.valueOf(0.0f));
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean hasBlock;
            Vec3 idealEndPos;
            this.update();
            Vec3 endPos = idealEndPos = MathUtil.rotationToPosition(this.m_20182_(), this.getRadius(), this.getPitch(), this.getYaw());
            RaytraceResult result = RayAttack.raytrace((LevelAccessor)this.m_9236_(), this, this.m_20182_(), idealEndPos);
            boolean bl = hasBlock = result.blockHitResult() != null && result.blockHitResult().m_6662_() != HitResult.Type.MISS;
            if (hasBlock) {
                endPos = result.blockHitResult().m_82450_();
            }
            this.setLength((float)endPos.m_82554_(this.m_20182_()));
            result = RayAttack.raytrace((LevelAccessor)this.m_9236_(), this, this.m_20182_(), endPos);
            this.onHit(result);
        } else {
            this.prevYaw = this.getYaw();
            this.prevPitch = this.getPitch();
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            Vec3 endPos = MathUtil.rotationToPosition(this.m_20182_(), this.getLength(), this.getPitch(), this.getYaw());
            this.addEndParticles(endPos);
        }
    }

    public int getRadius() {
        return 20;
    }

    public void onHit(RaytraceResult result) {
        for (Entity target : result.entities()) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)target;
            if (!this.getCaster().isEmpty() && living.m_20148_().equals(this.getCaster().get().m_20148_())) continue;
            this.doHurtTarget(living);
        }
    }

    public void doHurtTarget(LivingEntity target) {
        this.getCaster().ifPresent(caster -> EntityUtil.forceHurt(target, this.m_269291_().m_269549_(), this.getAttackDamage()));
    }

    public void addEndParticles(Vec3 endPos) {
        for (int i = 0; i < 4; ++i) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123813_, true, endPos.f_82479_ + (double)this.f_19796_.m_188501_() - 0.5, endPos.f_82480_ + (double)this.f_19796_.m_188501_() - 0.5, endPos.f_82481_ + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public float getRotationSpeed() {
        return 1.6f;
    }

    public float getAttackDamage() {
        return 3.0f;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    private void update() {
        this.updateRotations();
        this.updatePosition();
    }

    protected float rotateTowards(float from, float to, float maxAngle) {
        float f = Mth.m_14118_((float)from, (float)to);
        float f1 = Mth.m_14036_((float)f, (float)(-maxAngle), (float)maxAngle);
        return from + f1;
    }

    public void updateRotations() {
        this.getCaster().ifPresent(caster -> {
            if (caster instanceof LivingEntity) {
                RayAttackUser shooter;
                LivingEntity living = (LivingEntity)caster;
                if (caster instanceof RayAttackUser && !(shooter = (RayAttackUser)caster).isRayFollowingHeadRotation()) {
                    Vec3 idealEndPos = MathUtil.rotationToPosition(this.m_20182_(), this.getRadius(), this.getPitch(), this.getYaw());
                    shooter.updateRayEnd(idealEndPos);
                    Vec3 wantedPos = shooter.getRayRotationTarget();
                    float wantedYaw = MathUtil.positionToYaw(this.m_20182_(), wantedPos);
                    float wantedPitch = MathUtil.positionToPitch(this.m_20182_(), wantedPos);
                    float currentYaw = this.getYaw();
                    float currentPitch = this.getPitch();
                    this.setYaw(this.rotateTowards(currentYaw, wantedYaw, this.getRotationSpeed()));
                    this.setPitch(this.rotateTowards(currentPitch, wantedPitch, this.getRotationSpeed()));
                } else {
                    this.setYaw(living.f_20885_ + 90.0f);
                    this.setPitch(-caster.m_146909_());
                }
            }
        });
    }

    public void updatePosition() {
        this.getCaster().ifPresent(caster -> this.m_146884_(this.getPositionForCaster((Entity)caster, caster.m_20182_())));
    }

    public Vec3 getPositionForCaster(Entity caster, Vec3 casterPos) {
        return casterPos;
    }

    public static RaytraceResult raytrace(LevelAccessor level, Entity entity, Vec3 from, Vec3 to) {
        BlockHitResult hitResult = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        RaytraceResult result = new RaytraceResult(new ArrayList<Entity>(), (BlockHitResult)(hitResult.m_6662_() == HitResult.Type.BLOCK ? hitResult : null));
        List entities = level.m_45976_(Entity.class, new AABB(Math.min(from.f_82479_, to.f_82479_), Math.min(from.f_82480_, to.f_82480_), Math.min(from.f_82481_, to.f_82481_), Math.max(from.f_82479_, to.f_82479_), Math.max(from.f_82480_, to.f_82480_), Math.max(from.f_82481_, to.f_82481_)).m_82400_(1.0));
        for (Entity entity1 : entities) {
            AABB aabb = entity1.m_20191_().m_82400_((double)(entity1.m_6143_() + 0.5f));
            if (aabb.m_82390_(from)) {
                result.entities().add(entity1);
                continue;
            }
            if (!aabb.m_82371_(from, to).isPresent()) continue;
            result.entities().add(entity1);
        }
        result.entities().sort((o1, o2) -> (int)Math.signum(o1.m_20182_().m_82554_(from) - o2.m_20182_().m_82554_(from)));
        return result;
    }

    public record RaytraceResult(List<Entity> entities, BlockHitResult blockHitResult) {
    }
}

