/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.client.animation.ExampleGunItemAnimation;
import vzling.lib.client.model.ExampleGunItemModel;
import vzling.lib.client.model.ItemModel;
import vzling.lib.item.GunItem;
import vzling.lib.platform.VzlingPlatform;

public class ExampleGunItem
extends GunItem {
    public final VzlingAnimation IDLE = new VzlingAnimation(this, new ResourceLocation("vzling", "example_gun_idle"));
    public final VzlingAnimation SHOOT = new VzlingAnimation(this, new ResourceLocation("vzling", "example_gun_shoot"));
    public final VzlingAnimation EJECT = new VzlingAnimation(this, new ResourceLocation("vzling", "example_gun_eject"));
    public final VzlingAnimation CHECK = new VzlingAnimation(this, new ResourceLocation("vzling", "example_gun_check"));

    public ExampleGunItem(Item.Properties properties, float bulletDamage, float aimSpeed, int magSize) {
        super(properties, bulletDamage, aimSpeed, magSize);
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(ExampleGunItemAnimation.IDLE);
            this.SHOOT.setDefinition(ExampleGunItemAnimation.SHOOT);
            this.EJECT.setDefinition(ExampleGunItemAnimation.EJECT);
            this.CHECK.setDefinition(ExampleGunItemAnimation.CHECK);
        }
    }

    @Override
    public VzlingAnimation getShootAnimation() {
        return this.SHOOT;
    }

    @Override
    public VzlingAnimation getEjectAnimation() {
        return this.EJECT;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)Component.m_237115_((String)"item.vzling.example_gun.tooltip.0"));
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int time, boolean selected) {
        super.m_6883_(stack, level, entity, time, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_6117_()) {
                this.playAnimationIfStopped((Entity)player, this.IDLE);
            } else {
                this.stopAnimation((Entity)player, this.IDLE);
            }
        }
    }

    @Override
    public int getEjectDuration() {
        return 65;
    }

    @Override
    public int getEjectTick() {
        return 51;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemModel<ExampleGunItem> getModel() {
        return new ExampleGunItemModel<ExampleGunItem>(Minecraft.m_91087_().m_167973_().m_171103_(ExampleGunItemModel.LAYER_LOCATION));
    }

    @Override
    public boolean isSkilling() {
        return false;
    }

    @Override
    public void setSkilling(boolean skilling) {
    }

    @Override
    public int getSkillTick() {
        return 0;
    }

    @Override
    public void setSkillTick(int skillTick) {
    }

    @Override
    public int getSkillType() {
        return 0;
    }

    @Override
    public void setSkillType(int skillType) {
    }
}

