/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.platform;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import vzling.lib.platform.DeferredRegister;

public interface VzlingPlatform {
    public static final VzlingPlatform INSTANCE = (VzlingPlatform)Util.m_137537_(() -> {
        ServiceLoader<VzlingPlatform> loader = ServiceLoader.load(VzlingPlatform.class);
        Iterator<VzlingPlatform> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("Platform instance not found!");
        }
        VzlingPlatform platform = iterator.next();
        if (iterator.hasNext()) {
            throw new RuntimeException("More than one platform instance was found!");
        }
        return platform;
    });

    public boolean isClientSide();

    public <T> DeferredRegister<T> deferredRegister(String var1, ResourceKey<? extends Registry<T>> var2);

    default public SpawnEggItem spawnEggItem(Supplier<EntityType<? extends Mob>> supplier, int backgroundColor, int highlightColor, Item.Properties properties) {
        return new SpawnEggItem(supplier.get(), backgroundColor, highlightColor, properties);
    }

    public void startShake(Level var1, double var2, double var4, double var6, double var8, float var10, int var11);

    public void sendAnimationPacket(Level var1, int var2, int var3, ResourceLocation var4);

    public void gunPacket(int var1);

    public void sendDialogPacket(int var1, int var2, int var3, int var4, int var5);

    public void sendOpenDialogPacket(int var1, ServerPlayer var2);
}

