/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.json;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.joml.Vector3f;

public class GeoModelBuilder {
    private static final Map<String, GeometryModel.Bone> boneMap = new HashMap<String, GeometryModel.Bone>();

    public static class_630 build(GeometryModel model) {
        boolean changed;
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        HashMap<String, class_5610> parts = new HashMap<String, class_5610>();
        GeometryModel.Geometry geometry = model.minecraftGeometry.get(0);
        for (GeometryModel.Bone bone : geometry.bones) {
            boneMap.put(bone.name, bone);
        }
        for (GeometryModel.Bone bone : geometry.bones) {
            if (bone.parent != null && !bone.parent.isEmpty()) continue;
            class_5610 part = root.method_32117(bone.name, GeoModelBuilder.buildCubes(bone), GeoModelBuilder.buildPose(bone, null));
            GeoModelBuilder.addExtraCubes(bone, part);
            parts.put(bone.name, part);
        }
        do {
            changed = false;
            for (GeometryModel.Bone bone : geometry.bones) {
                if (parts.containsKey(bone.name) || bone.parent == null || bone.parent.isEmpty() || !parts.containsKey(bone.parent)) continue;
                class_5610 parentPart = (class_5610)parts.get(bone.parent);
                class_5610 part = parentPart.method_32117(bone.name, GeoModelBuilder.buildCubes(bone), GeoModelBuilder.buildPose(bone, boneMap.get(bone.parent)));
                GeoModelBuilder.addExtraCubes(bone, part);
                parts.put(bone.name, part);
                changed = true;
            }
        } while (changed);
        return class_5607.method_32110((class_5609)mesh, (int)geometry.description.textureWidth, (int)geometry.description.textureHeight).method_32109();
    }

    private static class_5606 buildCubes(GeometryModel.Bone bone) {
        class_5606 builder = class_5606.method_32108();
        if (bone.cubes != null) {
            for (int i = 0; i < bone.cubes.size(); ++i) {
                GeometryModel.Cube cube = bone.cubes.get(i);
                float x = GeoModelBuilder.convertOrigin(bone, cube, 0);
                float y = GeoModelBuilder.convertOrigin(bone, cube, 1);
                float z = GeoModelBuilder.convertOrigin(bone, cube, 2);
                if (cube.rotation != null && cube.pivot != null) continue;
                builder.method_32101(cube.uv[0], cube.uv[1]).method_32098(x, y, z, cube.size[0], cube.size[1], cube.size[2], new class_5605(cube.inflate));
            }
        }
        return builder;
    }

    private static void addExtraCubes(GeometryModel.Bone bone, class_5610 bonePart) {
        if (bone.cubes != null) {
            for (int i = 0; i < bone.cubes.size(); ++i) {
                GeometryModel.Cube cube = bone.cubes.get(i);
                if (cube.rotation == null && cube.pivot == null) continue;
                String cubeName = bone.name + "_cube_r" + i;
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                if (cube.rotation != null) {
                    rx = (float)Math.toRadians(cube.rotation[0]);
                    ry = (float)Math.toRadians(cube.rotation[1]);
                    rz = (float)Math.toRadians(cube.rotation[2]);
                }
                float px = GeoModelBuilder.convertPivotFromCube(cube, bone, 0);
                float py = GeoModelBuilder.convertPivotFromCube(cube, bone, 1);
                float pz = GeoModelBuilder.convertPivotFromCube(cube, bone, 2);
                float x = GeoModelBuilder.convertOriginFromCube(cube, 0);
                float y = GeoModelBuilder.convertOriginFromCube(cube, 1);
                float z = GeoModelBuilder.convertOriginFromCube(cube, 2);
                bonePart.method_32117(cubeName, class_5606.method_32108().method_32101(cube.uv[0], cube.uv[1]).method_32098(x, y, z, cube.size[0], cube.size[1], cube.size[2], new class_5605(cube.inflate)), class_5603.method_32091((float)px, (float)py, (float)pz, (float)rx, (float)ry, (float)rz));
            }
        }
    }

    private static class_5603 buildPose(GeometryModel.Bone bone, GeometryModel.Bone parentBone) {
        float rx = 0.0f;
        float ry = 0.0f;
        float rz = 0.0f;
        if (bone.rotation != null) {
            rx = (float)Math.toRadians(bone.rotation[0]);
            ry = (float)Math.toRadians(bone.rotation[1]);
            rz = (float)Math.toRadians(bone.rotation[2]);
        }
        float px = GeoModelBuilder.convertPivot(bone, parentBone, 0);
        float py = GeoModelBuilder.convertPivot(bone, parentBone, 1);
        float pz = GeoModelBuilder.convertPivot(bone, parentBone, 2);
        return class_5603.method_32091((float)px, (float)py, (float)pz, (float)rx, (float)ry, (float)rz);
    }

    public static class_809 buildItemTransforms(GeometryModel model) {
        GeometryModel.Geometry geometry = model.minecraftGeometry.get(0);
        if (geometry.itemDisplayTransforms == null) {
            return class_809.field_4301;
        }
        GeometryModel.ItemDisplayTransforms transforms = geometry.itemDisplayTransforms;
        class_804 thirdRight = GeoModelBuilder.convert(transforms.thirdpersonRighthand);
        class_804 thirdLeft = GeoModelBuilder.convert(transforms.thirdpersonLefthand);
        class_804 firstRight = GeoModelBuilder.convert(transforms.firstpersonRighthand);
        class_804 firstLeft = GeoModelBuilder.convert(transforms.firstpersonLefthand);
        class_804 gui = GeoModelBuilder.convert(transforms.gui);
        class_804 ground = GeoModelBuilder.convert(transforms.ground);
        class_804 fixed = GeoModelBuilder.convert(transforms.fixed);
        return new class_809(thirdLeft, thirdRight, firstLeft, firstRight, class_804.field_4284, gui, ground, fixed);
    }

    private static class_804 convert(GeometryModel.ItemDisplayContext context) {
        if (context == null) {
            return class_804.field_4284;
        }
        Vector3f rotation = new Vector3f((float)Math.toRadians(context.rotation[0]), (float)Math.toRadians(context.rotation[1]), (float)Math.toRadians(context.rotation[2]));
        Vector3f translation = new Vector3f(context.translation[0] * 0.0625f, context.translation[1] * 0.0625f, context.translation[2] * 0.0625f);
        Vector3f scale = new Vector3f(context.scale[0], context.scale[1], context.scale[2]);
        return new class_804(rotation, translation, scale);
    }

    private static float convertPivot(GeometryModel.Bone bone, GeometryModel.Bone parentBone, int index) {
        if (parentBone != null) {
            return index == 1 ? parentBone.pivot[index] - bone.pivot[index] : bone.pivot[index] - parentBone.pivot[index];
        }
        return index == 1 ? 24.0f - bone.pivot[index] : bone.pivot[index];
    }

    private static float convertPivotFromCube(GeometryModel.Cube cube, GeometryModel.Bone bone, int index) {
        if (bone != null) {
            return index == 1 ? bone.pivot[index] - cube.pivot[index] : cube.pivot[index] - bone.pivot[index];
        }
        return index == 1 ? 24.0f - cube.pivot[index] : cube.pivot[index];
    }

    private static float convertOrigin(GeometryModel.Bone bone, GeometryModel.Cube cube, int index) {
        return index == 1 ? bone.pivot[index] - cube.origin[index] - cube.size[index] : cube.origin[index] - bone.pivot[index];
    }

    private static float convertOriginFromCube(GeometryModel.Cube cube, int index) {
        return index == 1 ? cube.pivot[index] - cube.origin[index] - cube.size[index] : cube.origin[index] - cube.pivot[index];
    }

    public static class GeometryModel {
        @SerializedName(value="minecraft:geometry")
        public List<Geometry> minecraftGeometry;

        public static class ItemDisplayContext {
            public float[] rotation;
            public float[] translation;
            public float[] scale;
        }

        public static class ItemDisplayTransforms {
            @SerializedName(value="thirdperson_righthand")
            public ItemDisplayContext thirdpersonRighthand;
            @SerializedName(value="thirdperson_lefthand")
            public ItemDisplayContext thirdpersonLefthand;
            @SerializedName(value="firstperson_righthand")
            public ItemDisplayContext firstpersonRighthand;
            @SerializedName(value="firstperson_lefthand")
            public ItemDisplayContext firstpersonLefthand;
            public ItemDisplayContext ground;
            public ItemDisplayContext gui;
            public ItemDisplayContext fixed;
        }

        public static class Cube {
            public float[] origin;
            public float[] size;
            public float inflate = 0.0f;
            public float[] pivot;
            public float[] rotation;
            public int[] uv;
        }

        public static class Bone {
            public String name;
            public String parent;
            public float[] pivot;
            public float[] rotation;
            public List<Cube> cubes;
        }

        public static class Description {
            @SerializedName(value="texture_width")
            public int textureWidth;
            @SerializedName(value="texture_height")
            public int textureHeight;
        }

        public static class Geometry {
            public Description description;
            public List<Bone> bones;
            @SerializedName(value="item_display_transforms")
            public ItemDisplayTransforms itemDisplayTransforms;
        }
    }
}

