/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import vzling.lib.client.renderer.LightningBoltData;
import vzling.lib.client.renderer.LightningRender;
import vzling.lib.init.ParticleInit;

public class BlockLightningParticle
extends class_703 {
    private final LightningRender lightningRender = new LightningRender();

    public BlockLightningParticle(class_638 world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z);
        this.method_3080(6.0f, 6.0f);
        this.field_3874 = x;
        this.field_3854 = y;
        this.field_3871 = z;
        class_243 lightningTo = new class_243(xd - x, yd - y, zd - z);
        this.field_3847 = 10;
        int sections = 1 + (int)(9.0 * lightningTo.method_1033());
        LightningBoltData.BoltRenderInfo boltData = new LightningBoltData.BoltRenderInfo(0.4f, 0.1f, 0.1f, 0.7f, new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 0.7f), 0.1f);
        LightningBoltData bolt = new LightningBoltData(boltData, class_243.field_1353, lightningTo, sections).size(0.07f).lifespan(this.field_3847).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
        this.lightningRender.update((Object)this, bolt, 1.0f);
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            this.field_3869 -= (double)this.field_3844;
        }
    }

    public void method_3074(class_4588 consumer, class_4184 camera, float partialTick) {
        class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
        class_243 cameraPos = camera.method_19326();
        float x = (float)class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874);
        float y = (float)class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854);
        float z = (float)class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871);
        class_4587 posestack = new class_4587();
        posestack.method_22903();
        posestack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        posestack.method_46416(x, y, z);
        this.lightningRender.render(partialTick, posestack, (class_4597)multibuffersource$buffersource);
        multibuffersource$buffersource.method_22993();
        posestack.method_22909();
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public record OrbData(int r, int g, int b) implements class_2394
    {
        public static final class_2394.class_2395<OrbData> DESERIALIZER = new class_2394.class_2395<OrbData>(){

            @NotNull
            public OrbData fromCommand(class_2396<OrbData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new OrbData(r, g, b);
            }

            @NotNull
            public OrbData fromNetwork(class_2396<OrbData> particleTypeIn, class_2540 buffer) {
                return new OrbData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<OrbData> CODEC(class_2396<OrbData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(OrbData::r), (App)Codec.INT.fieldOf("g").forGetter(OrbData::g), (App)Codec.INT.fieldOf("b").forGetter(OrbData::b)).apply((Applicative)codecBuilder, OrbData::new));
        }

        public void method_10294(class_2540 buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        @NotNull
        public String method_10293() {
            return String.format(Locale.ROOT, "%s %d %d %d", class_7923.field_41180.method_10221(this.method_10295()), this.r, this.g, this.b);
        }

        @NotNull
        public class_2396<OrbData> method_10295() {
            return ParticleInit.BLOCK_LIGHTNING.get();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class OrbFactory
    implements class_707<OrbData> {
        public class_703 createParticle(OrbData typeIn, class_638 worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlockLightningParticle particle = new BlockLightningParticle(worldIn, x, y, z, (float)xSpeed, (float)ySpeed, (float)zSpeed, typeIn.r(), typeIn.g(), typeIn.b());
            return particle;
        }
    }
}

