/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

public class TrailParticle
extends AbstractTrailParticle {
    private static final class_2960 TRAIL_TEXTURE = new class_2960("vzling", "textures/particle/trail.png");
    private final double xPos;
    private final double yPos;
    private final double zPos;

    public TrailParticle(class_638 world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.field_3847 = 40;
        this.field_3844 = 0.0f;
        this.field_3874 = x;
        this.field_3854 = y;
        this.field_3871 = z;
        this.xPos = xd;
        this.yPos = yd;
        this.zPos = zd;
    }

    @Override
    public void method_3070() {
        float fade = 1.0f - (float)this.field_3866 / (float)this.field_3847;
        this.trailA = 0.8f * fade;
        class_243 class_2432 = new class_243(this.field_3874, this.field_3854, this.field_3871);
        class_243 class_2433 = new class_243(this.xPos, this.yPos, this.zPos);
        if (class_2432.method_1022(class_2433) <= 0.5) {
            this.field_3852 = 0.0;
            this.field_3869 = 0.0;
            this.field_3850 = 0.0;
        } else {
            this.field_3852 = new class_243(this.xPos, this.yPos, this.zPos).method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029().method_10216();
            this.field_3869 = new class_243(this.xPos, this.yPos, this.zPos).method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029().method_10214();
            this.field_3850 = new class_243(this.xPos, this.yPos, this.zPos).method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029().method_10215();
        }
        super.method_3070();
    }

    public int method_3068(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 0.5f;
    }

    @Override
    public class_2960 getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.field_3847 - this.field_3866);
    }

    public record ColorData(int r, int g, int b) implements class_2394
    {
        public static final class_2394.class_2395<ColorData> DESERIALIZER = new class_2394.class_2395<ColorData>(){

            public @NotNull ColorData fromCommand(class_2396<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new ColorData(r, g, b);
            }

            public @NotNull ColorData fromNetwork(class_2396<ColorData> particleTypeIn, class_2540 buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void method_10294(class_2540 buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        @NotNull
        public String method_10293() {
            return String.format(Locale.ROOT, "%s %d %d %d", class_7923.field_41180.method_10221(this.method_10295()), this.r, this.g, this.b);
        }

        @NotNull
        public class_2396<ColorData> method_10295() {
            return ParticleInit.TRAIL.get();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<ColorData> {
        public class_703 createParticle(ColorData data, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.r(), data.g(), data.b());
        }
    }
}

