/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import vzling.lib.client.animation.GeoAnimation;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.IAttackEntity;
import vzling.lib.entity.RayAttackUser;
import vzling.lib.entity.attack.AttackManager;
import vzling.lib.entity.attack.example_mob.FistAttack;
import vzling.lib.entity.attack.example_mob.KickAttack;
import vzling.lib.entity.attack.example_mob.SpellAttack;
import vzling.lib.entity.goal.EmptyMeleeAttackGoal;
import vzling.lib.entity.goal.LookAtTargetGoal;
import vzling.lib.util.MathUtil;
import vzling.lib.util.MiscUtil;

public class ExampleMobEntity
extends BossEntity
implements RayAttackUser {
    public final GeoAnimation IDLE = new GeoAnimation(this, new class_2960("vzling", "example_mob_idle"));
    public final GeoAnimation ATTACK = new GeoAnimation(this, new class_2960("vzling", "example_mob_attack"));
    public final GeoAnimation KICK = new GeoAnimation(this, new class_2960("vzling", "example_mob_kick"));
    public final GeoAnimation SPELL = new GeoAnimation(this, new class_2960("vzling", "example_mob_spell"));
    public final GeoAnimation PHASE = new GeoAnimation(this, new class_2960("vzling", "example_mob_phase"));
    public final GeoAnimation SPAWN = new GeoAnimation(this, new class_2960("vzling", "example_mob_spawn"));
    public final AttackManager<ExampleMobEntity> attackManager = new AttackManager<ExampleMobEntity>(this, List.of(new FistAttack(), new KickAttack(), new SpellAttack()));
    private final class_3213 bossEvent = new class_3213(this.method_5476(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795);

    public ExampleMobEntity(class_1299<? extends class_1588> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 1024.0);
    }

    @Override
    public void updatePhase() {
        if ((this.method_6032() <= this.method_6063() / 2.0f || this.updatePhase) && (this.getPhase() != 2 || this.updatePhase)) {
            if (!this.updatePhase) {
                MiscUtil.sendAnimationPacket(this.method_37908(), 0, this.method_5628(), this.PHASE.getId());
                this.phaseTick = 0;
                this.updatePhase = true;
            }
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
            this.setAttacking(false);
            this.setAttackTick(0);
            ++this.phaseTick;
            this.field_6008 = 20;
            if (this.phaseTick == 1) {
                this.method_43077(class_3417.field_14688);
            }
            if (this.phaseTick == 24) {
                this.method_43077(class_3417.field_14931);
                this.setPhase(2);
                MiscUtil.startShake(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 32.0, 6.0f, 20);
            }
            if (this.phaseTick >= 50) {
                this.updatePhase = false;
            }
        }
    }

    @Override
    public void spawn() {
        if (!this.isSpawned()) {
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
            this.setAttacking(false);
            this.setAttackTick(0);
            ++this.spawnTick;
            this.field_6008 = 20;
            if (this.spawnTick >= 20) {
                this.setSpawned(true);
            }
        }
    }

    @Override
    public boolean hasSpawnProcess() {
        return true;
    }

    @Override
    public void selectAttackType() {
        double random = this.method_6051().method_43058();
        if (random <= 0.44) {
            this.setAttackType(0);
        } else if (random <= 0.88) {
            this.setAttackType(1);
        } else {
            this.setAttackType(2);
        }
    }

    @Override
    public AttackManager<? extends IAttackEntity> getAttackManager() {
        return this.attackManager;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EmptyMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new LookAtTargetGoal((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42242)) {
            return super.method_5643(source, amount);
        }
        if (source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42249)) {
            return false;
        }
        return super.method_5643(source, Math.min(amount, 20.0f));
    }

    public void method_5773() {
        super.method_5773();
        this.playAnimationIfStopped((class_1309)this, this.IDLE);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals((Object)ATTACKING) && this.isAttacking()) {
            this.stopAllAnimStates();
            switch (this.getAttackType()) {
                case 0: {
                    this.playAnimation((class_1309)this, this.ATTACK);
                    break;
                }
                case 1: {
                    this.playAnimation((class_1309)this, this.KICK);
                    break;
                }
                case 2: {
                    this.playAnimation((class_1309)this, this.SPELL);
                }
            }
        }
        super.method_5674(accessor);
    }

    private void stopAllAnimStates() {
        this.stopAnimation((class_1309)this, this.ATTACK);
        this.stopAnimation((class_1309)this, this.KICK);
        this.stopAnimation((class_1309)this, this.SPELL);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    @Override
    public boolean isRayFollowingHeadRotation() {
        return true;
    }

    @Override
    public class_243 getRayRotationTarget() {
        return this.method_5968() == null ? this.method_19538().method_1031((double)(this.method_17681() * (this.method_6051().method_43057() - 0.5f)), (double)(this.method_17682() * this.method_6051().method_43057()), (double)(this.method_17681() * (this.method_6051().method_43057() - 0.5f))) : this.method_5968().method_19538().method_1031((double)(this.method_5968().method_17681() * (this.method_6051().method_43057() - 0.5f)), (double)(this.method_5968().method_17682() * this.method_6051().method_43057()), (double)(this.method_5968().method_17681() * (this.method_6051().method_43057() - 0.5f)));
    }

    @Override
    public void updateRayEnd(class_243 endPos) {
        this.method_36457(-MathUtil.positionToPitch(this.method_19538(), endPos));
        this.method_5847(MathUtil.positionToYaw(this.method_19538(), endPos) - 90.0f);
        this.method_36456(MathUtil.positionToYaw(this.method_19538(), endPos) - 90.0f);
    }
}

