/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.animation.GeoAnimation;
import vzling.lib.entity.BulletEntity;
import vzling.lib.init.AttributeInit;
import vzling.lib.init.ItemInit;
import vzling.lib.item.AbstractSkillItem;
import vzling.lib.item.skill.SkillManager;
import vzling.lib.item.skill.gun.EjectSkill;

public abstract class GunItem
extends AbstractSkillItem {
    protected static final UUID BASE_BULLET_DAMAGE_UUID = UUID.fromString("68953A94-9643-4C7D-B719-07D4836F1ADE");
    protected static final UUID BASE_AIM_SPEED_UUID = UUID.fromString("8E0AE044-DCFA-4988-9050-3F4DEDF69E9E");
    protected static final UUID BASE_MAG_SIZE_UUID = UUID.fromString("B7258774-2672-4047-92C9-D8D485945F12");
    private final float bulletDamage;
    private final float aimSpeed;
    private final int magSize;
    private final Multimap<class_1320, class_1322> defaultModifiers;
    public final SkillManager<GunItem> skillManager = new SkillManager<GunItem>(this, List.of(new EjectSkill(this.getEjectDuration())));

    public GunItem(class_1792.class_1793 properties, float bulletDamage, float aimSpeed, int magSize) {
        super(properties);
        this.bulletDamage = class_3532.method_15363((float)bulletDamage, (float)0.0f, (float)Float.MAX_VALUE);
        this.aimSpeed = class_3532.method_15363((float)aimSpeed, (float)0.01f, (float)10.0f);
        this.magSize = class_3532.method_15340((int)magSize, (int)1, (int)Integer.MAX_VALUE);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)AttributeInit.BULLET_DAMAGE.get(), (Object)new class_1322(BASE_BULLET_DAMAGE_UUID, "Weapon modifier", (double)this.bulletDamage, class_1322.class_1323.field_6328));
        builder.put((Object)AttributeInit.AIM_SPEED.get(), (Object)new class_1322(BASE_AIM_SPEED_UUID, "Weapon modifier", (double)this.aimSpeed, class_1322.class_1323.field_6330));
        builder.put((Object)AttributeInit.MAG_SIZE.get(), (Object)new class_1322(BASE_MAG_SIZE_UUID, "Weapon modifier", (double)this.magSize, class_1322.class_1323.field_6328));
        this.defaultModifiers = builder.build();
    }

    public float getBulletDamage() {
        return this.bulletDamage;
    }

    public float getAimSpeed() {
        return this.aimSpeed;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public abstract GeoAnimation getShootAnimation();

    public abstract GeoAnimation getEjectAnimation();

    public boolean shouldShootBullet(class_1799 stack) {
        return this.getBulletCount(stack) > 0;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_6079() == stack) {
            return class_1271.method_22430((Object)stack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)stack);
    }

    public boolean method_7885(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player) {
        return false;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int time, boolean selected) {
        class_1309 living;
        super.method_7888(stack, level, entity, time, selected);
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_6047() != stack) {
            stack.method_7948().method_10548("aimingProgress", 0.0f);
            stack.method_7948().method_10556("ejecting", false);
            stack.method_7948().method_10569("ejectTick", 0);
            this.stopAnimation(living, this.getEjectAnimation());
            this.stopAnimation(living, this.getShootAnimation());
        }
        if (stack.method_7969() == null || stack.method_7969().method_33133()) {
            stack.method_7948().method_10569("bulletCount", 20);
        }
        if (stack.method_7948().method_10577("ejecting")) {
            stack.method_7948().method_10569("ejectTick", stack.method_7948().method_10550("ejectTick") + 1);
            if (stack.method_7948().method_10550("ejectTick") == this.getEjectTick() && entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                this.eject(player, stack);
            }
            if (stack.method_7948().method_10550("ejectTick") >= this.getEjectDuration()) {
                stack.method_7948().method_10556("ejecting", false);
                stack.method_7948().method_10569("ejectTick", 0);
            }
        }
        if (entity instanceof class_1657) {
            class_1657 class_16572 = (class_1657)entity;
        }
    }

    public int getBulletCount(class_1799 stack) {
        if (stack.method_7969() != null) {
            return stack.method_7969().method_10550("bulletCount");
        }
        return 0;
    }

    public void shootBullet(class_1657 player, class_1799 stack) {
        BulletEntity bullet = this.getBullet(player.method_37908(), (class_1309)player);
        bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 8.0f, 0.0f);
        player.method_37908().method_8649((class_1297)bullet);
        if (stack.method_7969() != null) {
            stack.method_7969().method_10569("bulletCount", this.getBulletCount(stack) - 1);
        }
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 72000;
    }

    @NotNull
    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return equipmentSlot == class_1304.field_6173 ? this.defaultModifiers : super.method_7844(equipmentSlot);
    }

    public BulletEntity getBullet(class_1937 level, class_1309 shooter) {
        return new BulletEntity(level, shooter, this.getBulletDamage(), 255, 255, 255);
    }

    public void eject(class_1657 player, class_1799 stack) {
        int currentAmmo = this.getBulletCount(stack);
        int space = this.getMagSize() - currentAmmo;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 slot = player.method_31548().method_5438(i);
            if (slot.method_7909() != ItemInit.BULLET.get()) continue;
            int ammoToLoad = Math.min(space, slot.method_7947());
            if (stack.method_7969() != null) {
                stack.method_7969().method_10569("bulletCount", currentAmmo + ammoToLoad);
            }
            currentAmmo += ammoToLoad;
            slot.method_7934(ammoToLoad);
            if ((space -= ammoToLoad) <= 0) break;
        }
    }

    public SkillManager<GunItem> getSkillManager() {
        return this.skillManager;
    }

    public abstract int getEjectDuration();

    public abstract int getEjectTick();
}

